/*
 * Decompiled with CFR 0.152.
 */
package net.biville.florent.sproccompiler.export;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public class Either<L, R> {
    private final Optional<L> left;
    private final Optional<R> right;

    private Either(Optional<L> left, Optional<R> right) {
        this.left = left;
        this.right = right;
        if (left.isPresent() == right.isPresent()) {
            throw new IllegalStateException(String.format("Either left or right should be defined. Currently: [left: %s], [right: %s]", left, right));
        }
    }

    public static <L, R> Either<L, R> left(L value) {
        return new Either(Optional.of(value), Optional.empty());
    }

    public static <L, R> Either<L, R> right(R value) {
        return new Either(Optional.empty(), Optional.of(value));
    }

    public static <L, R> Either<Stream<L>, Stream<R>> combine(Stream<Either<L, R>> either) {
        ArrayList errors = new ArrayList();
        ArrayList results = new ArrayList();
        either.forEach(x -> x.consume(errors::add, results::add));
        if (!errors.isEmpty()) {
            return Either.left(errors.stream());
        }
        return Either.right(results.stream());
    }

    public <T> T map(Function<L, T> leftMapper, Function<R, T> rightMapper) {
        return (T)this.left.map(leftMapper).orElseGet(() -> this.right.map(rightMapper).get());
    }

    public <T> Either<T, R> mapLeft(Function<L, T> leftMapper) {
        return new Either<T, R>(this.left.map(leftMapper), this.right);
    }

    public <T> Either<L, T> mapRight(Function<R, T> rightMapper) {
        return new Either<L, T>(this.left, this.right.map(rightMapper));
    }

    public void consume(Consumer<L> leftConsumer, Consumer<R> rightConsumer) {
        this.left.ifPresent(leftConsumer);
        this.right.ifPresent(rightConsumer);
    }

    public String toString() {
        return "Either{left=" + this.left + ", right=" + this.right + '}';
    }
}

