/*
 * Decompiled with CFR 0.152.
 */
package net.biville.florent.sproccompiler.export.io;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.biville.florent.sproccompiler.export.Either;
import net.biville.florent.sproccompiler.export.messages.DsvExportError;

public class DsvFileWriter
implements AutoCloseable {
    private final Collection<String> header;
    private final Writer writer;
    private final String separator;
    private final boolean delimitFirstField;
    private final boolean quoteFields;

    public DsvFileWriter(Collection<String> header, Writer writer) {
        this(header, writer, ",", false, true);
    }

    public DsvFileWriter(Collection<String> header, Writer writer, String separator, boolean delimitFirstField, boolean quoteFields) {
        this.header = header;
        this.writer = writer;
        this.separator = separator;
        this.delimitFirstField = delimitFirstField;
        this.quoteFields = quoteFields;
    }

    public <T> void write(Stream<T> records, Function<T, Stream<Either<DsvExportError, String>>> rowFunction, Consumer<DsvExportError> onError) {
        this.writeRow(this.joinFields(this.header.stream()));
        records.forEach(record -> {
            Stream parsingResult = (Stream)rowFunction.apply(record);
            Either.combine(parsingResult).consume(errors -> errors.forEach(onError), result -> this.writeRow(this.joinFields((Stream<String>)result)));
        });
    }

    @Override
    public void close() {
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private String joinFields(Stream<String> fields) {
        String result = fields.map(field -> {
            if (this.quoteFields) {
                return "\"" + field.replace("\"", "\"\"") + "\"";
            }
            return field;
        }).collect(Collectors.joining(this.separator));
        if (this.delimitFirstField) {
            return this.separator + result;
        }
        return result;
    }

    private void writeRow(String row) {
        try {
            this.writer.write(row + "\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

