/*
 * Decompiled with CFR 0.152.
 */
package net.biville.florent.sproccompiler.visitors;

import java.util.Set;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.lang.model.util.Types;
import net.biville.florent.sproccompiler.compilerutils.TypeMirrorUtils;
import net.biville.florent.sproccompiler.messages.CompilationMessage;
import net.biville.florent.sproccompiler.messages.RecordTypeError;
import net.biville.florent.sproccompiler.visitors.RecordFieldTypeVisitor;

class RecordTypeVisitor
extends SimpleTypeVisitor8<Stream<CompilationMessage>, Void> {
    private final Types typeUtils;
    private final TypeVisitor<Boolean, Void> fieldTypeVisitor;

    public RecordTypeVisitor(Types typeUtils, TypeMirrorUtils typeMirrors) {
        this.typeUtils = typeUtils;
        this.fieldTypeVisitor = new RecordFieldTypeVisitor(typeUtils, typeMirrors);
    }

    @Override
    public Stream<CompilationMessage> visitDeclared(DeclaredType returnType, Void ignored) {
        return returnType.getTypeArguments().stream().flatMap(this::validateRecord);
    }

    private Stream<CompilationMessage> validateRecord(TypeMirror recordType) {
        Element recordElement = this.typeUtils.asElement(recordType);
        return Stream.concat(this.validateFieldModifiers(recordElement), this.validateFieldType(recordElement));
    }

    private Stream<CompilationMessage> validateFieldModifiers(Element recordElement) {
        return ElementFilter.fieldsIn(recordElement.getEnclosedElements()).stream().filter(element -> {
            Set<Modifier> modifiers = element.getModifiers();
            return !modifiers.contains((Object)Modifier.PUBLIC) && !modifiers.contains((Object)Modifier.STATIC);
        }).map(element -> new RecordTypeError((Element)element, "Record definition error: field %s#%s must be public", recordElement.getSimpleName(), element.getSimpleName()));
    }

    private Stream<CompilationMessage> validateFieldType(Element recordElement) {
        return ElementFilter.fieldsIn(recordElement.getEnclosedElements()).stream().filter(element -> !element.getModifiers().contains((Object)Modifier.STATIC)).filter(element -> this.fieldTypeVisitor.visit(element.asType()) == false).map(element -> new RecordTypeError((Element)element, "Record definition error: type of field %s#%s is not supported", recordElement.getSimpleName(), element.getSimpleName()));
    }
}

