/*
 * Decompiled with CFR 0.152.
 */
package net.biville.florent.sproccompiler.visitors;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor8;
import javax.lang.model.util.Types;
import net.biville.florent.sproccompiler.compilerutils.TypeMirrorUtils;
import net.biville.florent.sproccompiler.messages.CompilationMessage;
import net.biville.florent.sproccompiler.messages.FunctionInRootNamespaceError;
import net.biville.florent.sproccompiler.messages.ReturnTypeError;
import net.biville.florent.sproccompiler.validators.AllowedTypesValidator;
import net.biville.florent.sproccompiler.visitors.ParameterTypeVisitor;
import net.biville.florent.sproccompiler.visitors.ParameterVisitor;
import org.neo4j.procedure.UserFunction;

public class UserFunctionVisitor
extends SimpleElementVisitor8<Stream<CompilationMessage>, Void> {
    private final ElementVisitor<Stream<CompilationMessage>, Void> parameterVisitor;
    private final Predicate<TypeMirror> allowedTypesValidator;
    private final Elements elements;

    public UserFunctionVisitor(Types types, Elements elements, TypeMirrorUtils typeMirrorUtils) {
        this.parameterVisitor = new ParameterVisitor(new ParameterTypeVisitor(types, typeMirrorUtils));
        this.allowedTypesValidator = new AllowedTypesValidator(typeMirrorUtils, types);
        this.elements = elements;
    }

    @Override
    public Stream<CompilationMessage> visitExecutable(ExecutableElement method, Void ignored) {
        return Stream.concat(Stream.concat(this.validateParameters(method.getParameters(), ignored), this.validateName(method)), this.validateReturnType(method));
    }

    private Stream<CompilationMessage> validateParameters(List<? extends VariableElement> parameters, Void ignored) {
        return parameters.stream().flatMap(var -> this.parameterVisitor.visit((Element)var, ignored));
    }

    private Stream<CompilationMessage> validateName(ExecutableElement method) {
        UserFunction function = method.getAnnotation(UserFunction.class);
        String name = function.name();
        if (!name.isEmpty() && this.isInRootNamespace(name)) {
            return Stream.of(this.rootNamespaceError(method, name));
        }
        String value = function.value();
        if (!value.isEmpty() && this.isInRootNamespace(value)) {
            return Stream.of(this.rootNamespaceError(method, value));
        }
        PackageElement namespace = this.elements.getPackageOf(method);
        if (namespace == null) {
            return Stream.of(this.rootNamespaceError(method));
        }
        return Stream.empty();
    }

    private Stream<CompilationMessage> validateReturnType(ExecutableElement method) {
        TypeMirror returnType = method.getReturnType();
        if (!this.allowedTypesValidator.test(returnType)) {
            return Stream.of(new ReturnTypeError(method, "Unsupported return type <%s> of function defined in <%s#%s>.", returnType, method.getEnclosingElement(), method.getSimpleName()));
        }
        return Stream.empty();
    }

    private boolean isInRootNamespace(String name) {
        return !name.contains(".") || name.split("\\.")[0].isEmpty();
    }

    private FunctionInRootNamespaceError rootNamespaceError(ExecutableElement method, String name) {
        return new FunctionInRootNamespaceError(method, "Function <%s> cannot be defined in the root namespace. Valid name example: com.acme.my_function", name);
    }

    private FunctionInRootNamespaceError rootNamespaceError(ExecutableElement method) {
        return new FunctionInRootNamespaceError(method, "Function defined in <%s#%s> cannot be defined in the root namespace. Valid name example: com.acme.my_function", method.getEnclosingElement().getSimpleName(), method.getSimpleName());
    }
}

