/*
 * Decompiled with CFR 0.152.
 */
package net.bluemix.connectors.cloudfoundry.creator;

import java.util.Map;
import net.bluemix.connectors.core.info.CloudantServiceInfo;
import org.springframework.cloud.cloudfoundry.CloudFoundryServiceInfoCreator;
import org.springframework.cloud.cloudfoundry.Tags;

public class CloudantServiceInfoCreator
extends CloudFoundryServiceInfoCreator<CloudantServiceInfo> {
    public CloudantServiceInfoCreator() {
        super(new Tags(new String[0]), new String[]{"couchdb"});
    }

    public boolean accept(Map<String, Object> serviceData) {
        boolean result = false;
        Object obj = serviceData.get("label");
        if (obj instanceof String) {
            String label = (String)obj;
            result = "cloudantNoSQLDB".equals(label);
        }
        return result;
    }

    public CloudantServiceInfo createServiceInfo(Map<String, Object> serviceData) {
        String id = null;
        String username = null;
        String password = null;
        String host = null;
        int port = 0;
        String url = null;
        Object credObject = serviceData.get("credentials");
        Object idObj = serviceData.get("name");
        if (idObj instanceof String) {
            id = (String)idObj;
        }
        if (credObject instanceof Map) {
            Map credentials = (Map)credObject;
            Object usernameObj = credentials.get("username");
            Object passwordObj = credentials.get("password");
            Object hostObj = credentials.get("host");
            Object portObj = credentials.get("port");
            Object urlObj = credentials.get("url");
            if (usernameObj instanceof String) {
                username = (String)usernameObj;
            }
            if (passwordObj instanceof String) {
                password = (String)passwordObj;
            }
            if (hostObj instanceof String) {
                host = (String)hostObj;
            }
            if (portObj instanceof Integer) {
                port = (Integer)portObj;
            }
            if (urlObj instanceof String) {
                url = (String)urlObj;
            }
        }
        return new CloudantServiceInfo(id, username, password, host, port, url);
    }
}

