/*
 * Decompiled with CFR 0.152.
 */
package net.bluemix.connectors.cloudfoundry.creator;

import java.util.List;
import java.util.Map;
import org.springframework.cloud.cloudfoundry.CloudFoundryServiceInfoCreator;
import org.springframework.cloud.cloudfoundry.Tags;
import org.springframework.cloud.service.ServiceInfo;

public abstract class DatabasesForCloudServiceInfoCreator<SI extends ServiceInfo>
extends CloudFoundryServiceInfoCreator<SI> {
    String label;
    String connectionName;

    public DatabasesForCloudServiceInfoCreator(String label, String connectionName) {
        super(new Tags(new String[]{label}), (String[])null);
        this.label = label;
        this.connectionName = connectionName;
    }

    public boolean accept(Map<String, Object> serviceData) {
        if (this.labelMatches(serviceData)) {
            Map<String, Object> creds = this.getCredentials(serviceData);
            if (creds == null) {
                return false;
            }
            if (this.getId(serviceData) == null) {
                return false;
            }
            return this.getUriFromCredentials(creds) != null;
        }
        return false;
    }

    protected boolean labelMatches(Map<String, Object> serviceData) {
        String label = (String)serviceData.get("label");
        return this.label.equals(label);
    }

    protected Map<String, Object> getCredentials(Map<String, Object> serviceData) {
        return (Map)serviceData.get("credentials");
    }

    protected String getId(Map<String, Object> serviceData) {
        return (String)serviceData.get("name");
    }

    protected List<String> getUrisFromCredentials(Map<String, Object> credentials) {
        Map details;
        Map connection = (Map)credentials.get("connection");
        if (connection != null && (details = (Map)connection.get(this.connectionName)) != null) {
            List uris = (List)details.get("composed");
            return uris;
        }
        return null;
    }

    protected String getUriFromCredentials(Map<String, Object> credentials) {
        return this.getUrisFromCredentials(credentials).get(0);
    }

    protected String getHostFromCredentials(Map<String, Object> credentials) {
        Object h;
        List hosts;
        Map details;
        Map connection = (Map)credentials.get("connection");
        if (connection != null && (details = (Map)connection.get(this.connectionName)) != null && (hosts = (List)details.get("hosts")) != null && (h = ((Map)hosts.get(0)).get("hostname")) != null) {
            return h.toString();
        }
        return null;
    }

    protected String getPortFromCredentials(Map<String, Object> credentials) {
        Object h;
        List hosts;
        Map details;
        Map connection = (Map)credentials.get("connection");
        if (connection != null && (details = (Map)connection.get(this.connectionName)) != null && (hosts = (List)details.get("hosts")) != null && (h = ((Map)hosts.get(0)).get("port")) != null) {
            return h.toString();
        }
        return null;
    }

    protected String getSchemeFromCredentials(Map<String, Object> credentials) {
        Map details;
        Map connection = (Map)credentials.get("connection");
        if (connection != null && (details = (Map)connection.get(this.connectionName)) != null) {
            return (String)details.get("scheme");
        }
        return null;
    }

    protected String getPasswordFromCredentials(Map<String, Object> credentials) {
        Object h;
        Map auth;
        Map details;
        Map connection = (Map)credentials.get("connection");
        if (connection != null && (details = (Map)connection.get(this.connectionName)) != null && (auth = (Map)details.get("authentication")) != null && (h = auth.get("password")) != null) {
            return h.toString();
        }
        return null;
    }

    protected String getRootCaFromCredentials(Map<String, Object> credentials) {
        Map details;
        Map connection = (Map)credentials.get("connection");
        if (connection != null && (details = (Map)connection.get(this.connectionName)) != null) {
            Map certinfo = (Map)details.get("certificate");
            return (String)certinfo.get("certificate_base64");
        }
        return null;
    }
}

