/*
 * Decompiled with CFR 0.152.
 */
package net.bluemix.connectors.cloudfoundry.creator;

import java.util.Base64;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.bluemix.connectors.cloudfoundry.creator.DatabasesForCloudServiceInfoCreator;
import net.bluemix.connectors.core.ssl.StringBasedSSLSocketFactory;
import net.bluemix.connectors.core.ssl.StringBasedTrustManager;
import org.springframework.cloud.service.common.PostgresqlServiceInfo;

public class DatabasesForPostgresqlServiceInfoCreator
extends DatabasesForCloudServiceInfoCreator<PostgresqlServiceInfo> {
    private static final Logger LOG = Logger.getLogger(DatabasesForPostgresqlServiceInfoCreator.class.getName());

    public DatabasesForPostgresqlServiceInfoCreator() {
        super("databases-for-postgresql", "postgres");
    }

    public PostgresqlServiceInfo createServiceInfo(Map<String, Object> serviceData) {
        String uri;
        String id;
        block6: {
            id = this.getId(serviceData);
            Map<String, Object> credentials = this.getCredentials(serviceData);
            uri = this.getUriFromCredentials(credentials);
            String cert64 = this.getRootCaFromCredentials(credentials);
            if (cert64 != null && uri.contains("sslmode")) {
                if (!uri.contains("sslfactory")) {
                    try {
                        StringBasedTrustManager.getTrustManager().addCert(Base64.getDecoder().decode(cert64));
                        if (!uri.contains("?")) {
                            uri = uri + "?sslfactory=" + StringBasedSSLSocketFactory.class.getCanonicalName();
                            break block6;
                        }
                        uri = uri + "&sslfactory=" + StringBasedSSLSocketFactory.class.getCanonicalName();
                    }
                    catch (Exception e) {
                        LOG.log(Level.SEVERE, "Unable to add certificate to trust manager", e);
                    }
                } else {
                    LOG.log(Level.WARNING, "sslfactory already present in postgresql, not adding custom handler. Expect truststore issues.");
                }
            }
        }
        return new PostgresqlServiceInfo(id, uri);
    }
}

