/*
 * Decompiled with CFR 0.152.
 */
package net.bluemix.connectors.cloudfoundry.creator;

import java.util.Map;
import net.bluemix.connectors.core.info.TwilioServiceInfo;
import org.springframework.cloud.cloudfoundry.CloudFoundryServiceInfoCreator;
import org.springframework.cloud.cloudfoundry.Tags;

public class TwilioServiceInfoCreator
extends CloudFoundryServiceInfoCreator<TwilioServiceInfo> {
    private static final String TWILIO_API_URI = "https://api.twilio.com/";

    public TwilioServiceInfoCreator() {
        super(new Tags(new String[0]), new String[]{"https"});
    }

    public boolean accept(Map<String, Object> serviceData) {
        Map credentials;
        Object urlObj;
        Object credObject = serviceData.get("credentials");
        if (credObject instanceof Map && (urlObj = (credentials = (Map)credObject).get("twilio_api_base_url")) instanceof String) {
            return TWILIO_API_URI.equals((String)urlObj);
        }
        return false;
    }

    public TwilioServiceInfo createServiceInfo(Map<String, Object> serviceData) {
        String accountId = null;
        String authToken = null;
        String id = null;
        Object credObject = serviceData.get("credentials");
        Object idObj = serviceData.get("name");
        if (idObj instanceof String) {
            id = (String)idObj;
        }
        if (credObject instanceof Map) {
            Map credentials = (Map)credObject;
            Object accoutIdObj = credentials.get("twilio_account_sid");
            Object authTokenObj = credentials.get("twilio_auth_token");
            if (accoutIdObj instanceof String) {
                accountId = (String)accoutIdObj;
            }
            if (authTokenObj instanceof String) {
                authToken = (String)authTokenObj;
            }
        }
        return new TwilioServiceInfo(id, accountId, authToken);
    }
}

