/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import com.google.gson.GsonBuilder;
import java.util.UUID;
import javax.sql.DataSource;
import net.blugrid.core.dao.BlogArticleDAO;
import net.blugrid.core.dao.MediaObjectDAO;
import net.blugrid.core.dao.WebPageDAO;
import net.blugrid.core.model.BlogArticle;
import net.blugrid.core.model.BlogArticleResponse;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.MediaObject;
import net.blugrid.core.model.MediaObjectResponse;
import net.blugrid.core.model.ObjectResponse;
import net.blugrid.core.model.Token;
import net.blugrid.core.model.WebContentAssignment;
import net.blugrid.core.model.WebPage;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class BlogArticleDAOImpl
implements BlogArticleDAO {
    private static final Logger logger = Logger.getLogger(BlogArticleDAOImpl.class);
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;
    @Autowired
    private WebPageDAO WebPagedao;
    @Autowired
    private MediaObjectDAO MediaObjectdao;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getAll(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_blogarticle(   :token::t_pgpmessage,   NULL::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getByUUID(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_blogarticle(   :token::t_pgpmessage,   :inblogarticleuuid::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("inblogarticleuuid", (Object)uuid.toString());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public BlogArticleResponse post(Token Token2, BlogArticle blogArticle) {
        MediaObjectResponse mediaobjectresp;
        MediaObject mediaobject = new MediaObject();
        if (blogArticle.getMediaobject() != null && (mediaobjectresp = this.MediaObjectdao.post(Token2, blogArticle.getMediaobject())).getMediaobject() != null) {
            mediaobject = mediaobjectresp.getMediaobject();
            logger.info((Object)("posted media object uuid: " + mediaobject.getMediaobjectuuid().toString()));
        }
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json FROM proc_post_blogarticle(   :insessiontoken::t_pgpmessage,  :inblogarticleuuid::t_uuid,  :inblogarticletype::t_blogarticletype,  :inblogarticlename::t_descriptionshort,  :inblogarticledescription::t_description,  :inheadline::t_descriptionshort,  :inauthorpartyuuid::t_uuid,  :incommentcount::t_quantitycount,  :incontentrating::t_quantityshortcount,  :inwordcount::t_quantityshortcount,  :inblogarticlecontent::t_text,  :inpublishedtimestamp::t_timestampz,  :inhashtaglist::text[],   :inmediaobjectuuid::t_uuid,   :instatus::t_status  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("insessiontoken", (Object)Token2.getid_token());
        parameters.addValue("inblogarticleuuid", (Object)blogArticle.getBlogarticleuuid());
        parameters.addValue("inblogarticlename", (Object)blogArticle.getBlogarticlename());
        parameters.addValue("inblogarticletype", (Object)blogArticle.getBlogarticletype());
        parameters.addValue("inblogarticledescription", (Object)blogArticle.getBlogarticledescription());
        parameters.addValue("inheadline", (Object)blogArticle.getHeadline());
        if (blogArticle.getAuthor().getPartyuuid() != null) {
            parameters.addValue("inauthorpartyuuid", (Object)blogArticle.getAuthor().getPartyuuid().toString());
        } else {
            parameters.addValue("inpartyuuid", null);
        }
        parameters.addValue("incommentcount", (Object)blogArticle.getCommentcount());
        parameters.addValue("incontentrating", (Object)blogArticle.getContentrating());
        parameters.addValue("inwordcount", (Object)blogArticle.getWordcount());
        parameters.addValue("inblogarticlecontent", (Object)blogArticle.getBlogarticlecontent());
        parameters.addValue("inpublishedtimestamp", (Object)blogArticle.getPublishedtimestamp());
        parameters.addValue("instatus", (Object)blogArticle.getStatus());
        if (mediaobject != null) {
            parameters.addValue("inmediaobjectuuid", (Object)mediaobject.getMediaobjectuuid());
        } else {
            parameters.addValue("inmediaobjectuuid", null);
        }
        parameters.addValue("inhashtaglist", (Object)blogArticle.getHashtagStringList());
        JsonData jsondata = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        BlogArticleResponse response = (BlogArticleResponse)new GsonBuilder().create().fromJson(jsondata.getJson(), BlogArticleResponse.class);
        if (blogArticle.getWebpages() != null && response.getStatus().equalsIgnoreCase("OK") && response.getBlogarticle().getBlogarticleuuid() != null) {
            for (int i = 0; i < blogArticle.getWebpages().size(); ++i) {
                WebPage webpage = (WebPage)blogArticle.getWebpages().get(i);
                if (webpage.getWebpagetemplate() == null) continue;
                WebContentAssignment webcontentassignment = new WebContentAssignment();
                webcontentassignment.setBlogarticleuuid(response.getBlogarticle().getBlogarticleuuid());
                webcontentassignment.setWebcontentassignmenttype("BlogArticle");
                webcontentassignment.setStatus("Active");
                webpage.setWebcontentassignment(webcontentassignment);
                webpage.setBlogarticleuuid(response.getBlogarticle().getBlogarticleuuid());
                ObjectResponse<WebPage> webpageResponse = this.WebPagedao.postByUUID(Token2, webpage);
                if (!webpageResponse.getStatus().equalsIgnoreCase("OK") || webpageResponse.getData() == null) continue;
                blogArticle.getWebpages().set(i, webpageResponse.getData());
                logger.info((Object)("posted webpage uuid: " + ((WebPage)webpageResponse.getData()).getWebpageuuid().toString()));
            }
        }
        return response;
    }
}

