/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import java.util.UUID;
import javax.sql.DataSource;
import net.blugrid.core.dao.ColorPaletteDAO;
import net.blugrid.core.model.Color;
import net.blugrid.core.model.ColorPalette;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.Token;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ColorPaletteDAOImpl
implements ColorPaletteDAO {
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getAll(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_colorpalette(    :token::t_pgpmessage,    NULL::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getByUUID(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_colorpalette(    :token::t_pgpmessage,    :incolorpaletteuuid::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("incolorpaletteuuid", (Object)uuid.toString());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String postColorPalette(Token token, ColorPalette colorpalette) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_post_colorpalette(    :token::t_pgpmessage,    :incolorpaletteuuid::t_uuid,   :incolorpalettename::t_name,    :incolorpalettedescription::t_name,    :inbranduuid::t_uuid,   :instatus::t_status  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        if (colorpalette.getColorpaletteuuid() != null) {
            parameters.addValue("incolorpaletteuuid", (Object)colorpalette.getColorpaletteuuid());
        } else {
            parameters.addValue("incolorpaletteuuid", null);
        }
        parameters.addValue("incolorpalettename", (Object)colorpalette.getColorpalettename());
        parameters.addValue("incolorpalettedescription", (Object)colorpalette.getColorpalettedescription());
        parameters.addValue("inbranduuid", (Object)colorpalette.getBranduuid());
        parameters.addValue("instatus", (Object)colorpalette.getStatus());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String postColor(Token token, Color color) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_post_color(    :token::t_pgpmessage,    :incolorpaletteuuid::t_uuid,   :inhex::t_hexint,    :in_r::t_shortcount,   :in_g::t_shortcount,   :in_b::t_shortcount,   :incolorname::t_name,   :inhexcode::t_code,   :inrgbcode::t_code,    :instatus::t_status  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        if (color.getColorpaletteuuid() != null) {
            parameters.addValue("incolorpaletteuuid", (Object)color.getColorpaletteuuid());
        } else {
            parameters.addValue("incolorpaletteuuid", null);
        }
        String hexstr = color.getHexcode().replaceAll("#", "");
        Long hexint = Long.parseLong(hexstr, 16);
        parameters.addValue("inhex", (Object)hexint);
        parameters.addValue("in_r", (Object)color.getR());
        parameters.addValue("in_g", (Object)color.getG());
        parameters.addValue("in_b", (Object)color.getB());
        parameters.addValue("incolorname", (Object)color.getColorname());
        parameters.addValue("inhexcode", (Object)color.getHexcode());
        parameters.addValue("inrgbcode", (Object)color.getRgbcode());
        parameters.addValue("instatus", (Object)color.getStatus());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }
}

