/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import java.util.UUID;
import javax.sql.DataSource;
import net.blugrid.core.dao.DocumentFolderDAO;
import net.blugrid.core.model.DocumentFolder;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.Response;
import net.blugrid.core.model.Token;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class DocumentFolderDAOImpl
implements DocumentFolderDAO {
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getAll(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_documentfolder(   :token::t_pgpmessage,   NULL::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getByUUID(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_documentfolder(   :token::t_pgpmessage,   :indocumentfolderuuid::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("indocumentfolderuuid", (Object)uuid.toString());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public DocumentFolder post(Token Token2, DocumentFolder documentfolder) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outdocumentfolderuuid as documentfolderuuid FROM proc_post_documentfolder(   :insessiontoken::t_pgpmessage,  :indocumentfolderuuid::t_uuid,  :indocumentfoldername::t_descriptionshort,   :indocumentfolderdescription::t_description  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("insessiontoken", (Object)Token2.getid_token());
        parameters.addValue("indocumentfolderuuid", (Object)documentfolder.getDocumentfolderuuid());
        parameters.addValue("indocumentfoldername", (Object)documentfolder.getDocumentfoldername());
        parameters.addValue("indocumentfolderdescription", (Object)documentfolder.getDocumentfolderdescription());
        DocumentFolder uuid = (DocumentFolder)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(DocumentFolder.class));
        documentfolder.setDocumentfolderuuid(uuid.getDocumentfolderuuid());
        return documentfolder;
    }

    @Override
    public Response deleteByUUID(Token token, DocumentFolder documentfolder) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outstatus as status,    outsource as source,    outmessage as message FROM proc_del_documentfolder(   :sessiontoken::t_pgpmessage,   :documentfolderuuid::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("sessiontoken", (Object)token.getid_token());
        parameters.addValue("documentfolderuuid", (Object)documentfolder.getDocumentfolderuuid());
        Response response = (Response)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(Response.class));
        return response;
    }
}

