/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import net.blugrid.core.dao.AudienceDAO;
import net.blugrid.core.dao.EmailMessageDAO;
import net.blugrid.core.dao.ScheduleDAO;
import net.blugrid.core.dao.TargetLocationDAO;
import net.blugrid.core.dao.WebContentDAO;
import net.blugrid.core.model.AudienceResponse;
import net.blugrid.core.model.EmailMessage;
import net.blugrid.core.model.EmailMessageResponse;
import net.blugrid.core.model.EmailWebContent;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.MessageAttachment;
import net.blugrid.core.model.MessageInstance;
import net.blugrid.core.model.MessageInstanceResponse;
import net.blugrid.core.model.MessageRecipient;
import net.blugrid.core.model.MessageRecipientResponse;
import net.blugrid.core.model.ObjectResponse;
import net.blugrid.core.model.ScheduleResponse;
import net.blugrid.core.model.TargetLocationResponse;
import net.blugrid.core.model.Token;
import net.blugrid.core.utils.PostgresqlJson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class EmailMessageDAOImpl
implements EmailMessageDAO {
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;
    private EmailMessage emailMessage;
    @Autowired
    private ScheduleDAO Scheduledao;
    @Autowired
    private AudienceDAO AudienceDAO;
    @Autowired
    private TargetLocationDAO TargetLocationdao;
    @Autowired
    private WebContentDAO Webcontentdao;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getAll(Token token, String emailtype) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_email(    :token::t_pgpmessage,    :emailtype::t_emailtype,    NULL::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("emailtype", (Object)emailtype);
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getByUUID(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_email(    :token::t_pgpmessage,    :inmessageuuid::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("inmessageuuid", (Object)uuid.toString());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getWebmail(UUID clientuuid, UUID messageuuid, UUID trackinguuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_webmail(    :inclientuuid::t_uuid,    :inmessageuuid::t_uuid,    :intrackinguuid::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("inclientuuid", (Object)clientuuid.toString());
        parameters.addValue("inmessageuuid", (Object)messageuuid.toString());
        parameters.addValue("intrackinguuid", (Object)trackinguuid.toString());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public EmailMessage getObjectByUUID(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_email_emailservice(    :token::t_pgpmessage,    :inmessageuuid::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("inmessageuuid", (Object)uuid.toString());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        EmailMessage response = (EmailMessage)new GsonBuilder().create().fromJson(json.getJson(), EmailMessage.class);
        return response;
    }

    @Override
    public EmailMessageResponse post(Token token, EmailMessage email) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json  FROM proc_post_email(   :token::t_pgpmessage,   :inmessageuuid::t_uuid,   :inemailtemplateuuid::t_uuid,   :infrompartyuuid::t_uuid,   :inmessagetext::t_text,   :insubject::t_name,   :inccsender::t_flag,   :inrecipientselectionmethod::t_partyselectionmethod,   :insendnowflag::t_flag,   :inemailserviceuuid::t_uuid,   :inbranduuid::t_uuid,   :inaudienceuuid::t_uuid,  :intargetlocationuuid::t_uuid,  :inscheduleuuid::t_uuid,   :intopartyuuidlist::text[],   :instatus::t_status ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("inmessageuuid", (Object)email.getMessageuuid());
        if (email.getEmailtemplate() != null) {
            parameters.addValue("inemailtemplateuuid", (Object)email.getEmailtemplate().getEmailtemplateuuid());
        } else {
            parameters.addValue("inemailtemplateuuid", null);
        }
        parameters.addValue("infrompartyuuid", (Object)email.getFromparty().getPartyuuid());
        parameters.addValue("inmessagetext", (Object)email.getMessagetext());
        parameters.addValue("insubject", (Object)email.getSubject());
        parameters.addValue("inccsender", (Object)email.getCcsender());
        parameters.addValue("inrecipientselectionmethod", (Object)email.getRecipientselectionmethod());
        parameters.addValue("insendnowflag", (Object)email.getSendnowflag());
        parameters.addValue("instatus", (Object)email.getStatus());
        if (email.getEmailservice() != null) {
            parameters.addValue("inemailserviceuuid", (Object)email.getEmailservice().getEmailserviceuuid());
        } else {
            parameters.addValue("inemailserviceuuid", null);
        }
        if (email.getBrand() != null) {
            parameters.addValue("inbranduuid", (Object)email.getBrand().getBranduuid());
        } else {
            parameters.addValue("inbranduuid", null);
        }
        if (email.getAudience().getAudienceuuid() != null) {
            AudienceResponse audienceresponse = this.AudienceDAO.post(token, email.getAudience());
            if (audienceresponse.getStatus().equalsIgnoreCase("OK")) {
                parameters.addValue("inaudienceuuid", (Object)audienceresponse.getAudience().getAudienceuuid());
            }
        } else {
            parameters.addValue("inaudienceuuid", null);
        }
        if (email.getTargetlocation().getTargetlocationuuid() != null) {
            TargetLocationResponse targetlocationresponse = this.TargetLocationdao.post(token, email.getTargetlocation());
            if (targetlocationresponse.getStatus().equalsIgnoreCase("OK")) {
                parameters.addValue("intargetlocationuuid", (Object)targetlocationresponse.getTargetlocation().getTargetlocationuuid());
            }
        } else {
            parameters.addValue("intargetlocationuuid", null);
        }
        if (email.getSchedule() != null) {
            ScheduleResponse schedresponse = this.Scheduledao.post(token, email.getSchedule());
            if (schedresponse.getStatus().equalsIgnoreCase("OK")) {
                parameters.addValue("inscheduleuuid", (Object)schedresponse.getSchedule().getScheduleuuid());
            }
        } else {
            parameters.addValue("inscheduleuuid", null);
        }
        ArrayList<String> topartylist = new ArrayList<String>();
        for (int j = 0; j < email.getMessagerecipients().size(); ++j) {
            String prtyuuid = ((MessageRecipient)email.getMessagerecipients().get(j)).getRecipient().getPartyuuid().toString();
            topartylist.add(prtyuuid);
        }
        String topartystr = ((Object)topartylist).toString();
        topartystr = topartystr.replace("[", "{");
        topartystr = topartystr.replace("]", "}");
        parameters.addValue("intopartyuuidlist", (Object)topartystr);
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        EmailMessageResponse response = (EmailMessageResponse)new GsonBuilder().create().fromJson(json.getJson(), EmailMessageResponse.class);
        if (response.getStatus().equalsIgnoreCase("OK")) {
            this.emailMessage = response.getEmailmessage();
            if (response.getEmailmessage() != null && !email.getWebcontent().isEmpty()) {
                UUID messageuuid = response.getEmailmessage().getMessageuuid();
                ArrayList<EmailWebContent> webcontentlist = new ArrayList<EmailWebContent>();
                for (int i = 0; i < email.getWebcontent().size(); ++i) {
                    if (((EmailWebContent)email.getWebcontent().get(i)).getStatus() == null) {
                        ((EmailWebContent)email.getWebcontent().get(i)).setStatus("Active");
                    }
                    ((EmailWebContent)email.getWebcontent().get(i)).setMessageuuid(messageuuid);
                    EmailWebContent webcontent = this.Webcontentdao.postEmailWebContent(token, (EmailWebContent)email.getWebcontent().get(i));
                    webcontentlist.add(webcontent);
                }
                response.getEmailmessage().setWebcontent(webcontentlist);
            }
            if (email.getMessagerecipients() != null) {
                List<MessageRecipient> recps = this.postMessageRecipientList(token, email.getMessagerecipients());
                response.getEmailmessage().setMessagerecipients(recps);
            }
            if (email.getMessageinstances() != null) {
                List<MessageInstance> inst = this.postMessageInstanceList(token, email.getMessageinstances());
                response.getEmailmessage().setMessageinstances(inst);
            }
            if (email.getAttachments() != null) {
                List<MessageAttachment> attachments = this.postMessageAttachmentList(token, email.getAttachments());
                response.getEmailmessage().setAttachments(attachments);
            }
        }
        return response;
    }

    @Override
    public String getRecipientList(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_email_message_recipient_list(    :token::t_pgpmessage,    :inmessageuuid::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("inmessageuuid", (Object)uuid.toString());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public List<MessageInstance> postMessageInstanceList(Token token, List<MessageInstance> messageinstances) {
        ArrayList<MessageInstance> response = new ArrayList<MessageInstance>();
        for (int i = 0; i < messageinstances.size(); ++i) {
            if (messageinstances.get(i).getMessageuuid() == null) {
                messageinstances.get(i).setMessageuuid(this.emailMessage.getMessageuuid());
            }
            if (messageinstances.get(i).getTrackinguuid() == null) {
                messageinstances.get(i).setTrackinguuid(UUID.randomUUID());
            }
            MessageInstance messageinstance = this.postMessageInstance(token, messageinstances.get(i));
            response.add(messageinstance);
        }
        return response;
    }

    @Override
    public MessageInstance postMessageInstance(Token token, MessageInstance messageisntance) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json FROM proc_post_message_instance(    :insessiontoken::t_pgpmessage,    :inmessageuuid::t_uuid,    :inpartyuuid::t_uuid,    :intrackinguuid::t_uuid,    :insenttime::t_timestampz,    :inmessagestring::t_text,    :ineventuuid::t_uuid,    :intransactionuuid::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("insessiontoken", (Object)token.getid_token());
        parameters.addValue("inmessageuuid", (Object)messageisntance.getMessageuuid());
        if (messageisntance.getRecipient() != null) {
            parameters.addValue("inpartyuuid", (Object)messageisntance.getRecipient().getPartyuuid());
        } else {
            parameters.addValue("inpartyuuid", null);
        }
        if (messageisntance.getTrackinguuid() == null) {
            messageisntance.setTrackinguuid(UUID.randomUUID());
        }
        parameters.addValue("intrackinguuid", (Object)messageisntance.getTrackinguuid());
        parameters.addValue("insenttime", (Object)messageisntance.getSenttime());
        parameters.addValue("inmessagestring", (Object)messageisntance.getMessagestring());
        if (messageisntance.getEventuuid() != null) {
            parameters.addValue("ineventuuid", (Object)messageisntance.getEventuuid());
        } else {
            parameters.addValue("ineventuuid", null);
        }
        if (messageisntance.getTransactionuuid() != null) {
            parameters.addValue("intransactionuuid", (Object)messageisntance.getTransactionuuid());
        } else {
            parameters.addValue("intransactionuuid", null);
        }
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        MessageInstanceResponse response = (MessageInstanceResponse)new GsonBuilder().create().fromJson(json.getJson(), MessageInstanceResponse.class);
        return response.getMessageinstance();
    }

    @Override
    public List<MessageRecipient> postMessageRecipientList(Token token, List<MessageRecipient> recipientList) {
        ArrayList<MessageRecipient> response = new ArrayList<MessageRecipient>();
        for (int i = 0; i < recipientList.size(); ++i) {
            if (recipientList.get(i).getMessageuuid() == null) {
                recipientList.get(i).setMessageuuid(this.emailMessage.getMessageuuid());
            }
            if (recipientList.get(i).getTrackinguuid() == null) {
                recipientList.get(i).setTrackinguuid(UUID.randomUUID());
            }
            MessageRecipient messagerecp = this.postMessageRecipient(token, recipientList.get(i));
            response.add(messagerecp);
        }
        return response;
    }

    @Override
    public MessageRecipient postMessageRecipient(Token token, MessageRecipient recipient) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json FROM proc_post_email_recipient(    :insessiontoken::t_pgpmessage,    :inmessageuuid::t_uuid,    :inpartyuuid::t_uuid,    :intrackinguuid::t_uuid,    :insenttime::t_timestampz,    :inmessagestring::t_text ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("insessiontoken", (Object)token.getid_token());
        parameters.addValue("inmessageuuid", (Object)recipient.getMessageuuid());
        if (recipient.getRecipient() != null) {
            parameters.addValue("inpartyuuid", (Object)recipient.getRecipient().getPartyuuid());
        } else {
            parameters.addValue("inpartyuuid", null);
        }
        if (recipient.getTrackinguuid() != null) {
            parameters.addValue("intrackinguuid", (Object)recipient.getTrackinguuid());
        } else {
            parameters.addValue("intrackinguuid", null);
        }
        parameters.addValue("insenttime", (Object)recipient.getSenttime());
        parameters.addValue("inmessagestring", (Object)recipient.getMessagestring());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        MessageRecipientResponse response = PostgresqlJson.jsonToMessageRecipientResponse((String)json.getJson());
        return response.getMessagerecipient();
    }

    @Override
    public List<MessageAttachment> postMessageAttachmentList(Token token, List<MessageAttachment> attachments) {
        ArrayList<MessageAttachment> response = new ArrayList<MessageAttachment>();
        for (int i = 0; i < attachments.size(); ++i) {
            if (attachments.get(i).getMessageuuid() == null) {
                attachments.get(i).setMessageuuid(this.emailMessage.getMessageuuid());
            }
            MessageAttachment messageattachment = this.postMessageAttachment(token, attachments.get(i));
            response.add(messageattachment);
        }
        return response;
    }

    @Override
    public MessageAttachment postMessageAttachment(Token token, MessageAttachment attachment) {
        if (attachment.getMessageuuid() != null && attachment.getFileobject() != null) {
            NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
            String sql = "SELECT outjson AS json FROM proc_post_message_attachment(    :insessiontoken::t_pgpmessage,    :inmessageuuid::t_uuid,    :infileuuid::t_uuid,    :inname::t_name,    :inurl::t_urladdress,    :infilename::t_descriptionshort,    :instatus::t_status ) ";
            MapSqlParameterSource parameters = new MapSqlParameterSource();
            parameters.addValue("insessiontoken", (Object)token.getid_token());
            parameters.addValue("inmessageuuid", (Object)attachment.getMessageuuid());
            parameters.addValue("infileuuid", (Object)attachment.getFileobject().getFileuuid());
            parameters.addValue("inname", (Object)attachment.getFileobject().getFilename());
            parameters.addValue("inurl", (Object)attachment.getFileobject().getUrl());
            parameters.addValue("infilename", (Object)attachment.getFileobject().getFilename());
            parameters.addValue("instatus", (Object)attachment.getStatus());
            JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
            Type type = new TypeToken<ObjectResponse<MessageAttachment>>(){}.getType();
            ObjectResponse response = (ObjectResponse)new Gson().fromJson(json.getJson(), type);
            return (MessageAttachment)response.getData();
        }
        return null;
    }
}

