/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.UUID;
import javax.sql.DataSource;
import net.blugrid.core.dao.EmailTemplateDAO;
import net.blugrid.core.dao.WebContentAssignmentDAO;
import net.blugrid.core.dao.WebContentDAO;
import net.blugrid.core.model.EmaiTemplateWebContent;
import net.blugrid.core.model.EmailTemplate;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.ObjectResponse;
import net.blugrid.core.model.Token;
import net.blugrid.core.model.WebContent;
import net.blugrid.core.model.WebContentAssignment;
import net.blugrid.core.utils.PostgresqlJson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class EmailTemplateDAOImpl
implements EmailTemplateDAO {
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;
    @Autowired
    private WebContentDAO Webcontentdao;
    @Autowired
    private WebContentAssignmentDAO webcontentassignmentdao;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getAll(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_emailtemplate(   :token::t_pgpmessage,   NULL::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public String getByUUID(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_emailtemplate(   :token::t_pgpmessage,   :uuid::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("uuid", (Object)uuid);
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        String response = json.getJson();
        return response;
    }

    @Override
    public ObjectResponse<EmailTemplate> post(Token token, EmailTemplate emailtemplate) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json  FROM proc_post_emailtemplate(   :token::t_pgpmessage,   :inemailtemplateuuid::t_uuid,   :inemailtemplatename::t_name,   :inmessagetext::t_text,   :insubject::t_name,   :inemailtemplatetype::t_emailtemplatetype,   :inemailserviceuuid::t_uuid,   :inbranduuid::t_uuid,   :instatus::t_status ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("inemailtemplateuuid", (Object)emailtemplate.getEmailtemplateuuid());
        parameters.addValue("inemailtemplatename", (Object)emailtemplate.getEmailtemplatename());
        parameters.addValue("inmessagetext", (Object)emailtemplate.getMessagetext());
        parameters.addValue("insubject", (Object)emailtemplate.getSubject());
        parameters.addValue("inemailtemplatetype", (Object)emailtemplate.getEmailtemplatetype());
        if (emailtemplate.getEmailservice() != null) {
            parameters.addValue("inemailserviceuuid", (Object)emailtemplate.getEmailservice().getEmailserviceuuid());
        } else {
            parameters.addValue("inemailserviceuuid", null);
        }
        if (emailtemplate.getBrand() != null) {
            parameters.addValue("inbranduuid", (Object)emailtemplate.getBrand().getBranduuid());
        } else {
            parameters.addValue("inbranduuid", null);
        }
        parameters.addValue("instatus", (Object)emailtemplate.getStatus());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        Type type = new TypeToken<ObjectResponse<EmailTemplate>>(){}.getType();
        ObjectResponse response = (ObjectResponse)new Gson().fromJson(json.getJson(), type);
        if (response.getStatus().equalsIgnoreCase("OK") && response.getData() != null) {
            ArrayList<WebContent> tplcontent = new ArrayList<WebContent>();
            if (!emailtemplate.getWebcontent().isEmpty()) {
                for (int i = 0; i < emailtemplate.getWebcontent().size(); ++i) {
                    WebContent webcontent = (WebContent)emailtemplate.getWebcontent().get(i);
                    webcontent.setEmailtemplateuuid(((EmailTemplate)response.getData()).getEmailtemplateuuid());
                    webcontent = this.postEmailContentTemplate(token, webcontent);
                    tplcontent.add(webcontent);
                }
                ((EmailTemplate)response.getData()).setWebcontent(tplcontent);
            }
        }
        return response;
    }

    private WebContent postEmailContentTemplate(Token token, WebContent webcontent) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json  FROM proc_post_emailtemplatewebcontent(   :token::t_pgpmessage,   :inwebcontentuuid::t_uuid,   :inwebcontentname::t_name,   :inwebcontenttemplateiduuid::t_uuid,   :inblogarticleuuid::t_uuid,   :inemailtemplateuuid::t_uuid,   :inmodeldata::t_json,   :insequence::t_identity,   :instatus::t_status ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("inwebcontentuuid", (Object)webcontent.getWebcontentuuid());
        parameters.addValue("inwebcontentname", (Object)webcontent.getWebcontentname());
        parameters.addValue("inwebcontenttemplateiduuid", (Object)webcontent.getWebcontenttemplate().getWebcontenttemplateuuid());
        parameters.addValue("inblogarticleuuid", (Object)webcontent.getBlogarticleuuid());
        parameters.addValue("inemailtemplateuuid", (Object)webcontent.getEmailtemplateuuid());
        parameters.addValue("inmodeldata", webcontent.getModeldata());
        parameters.addValue("insequence", (Object)webcontent.getSequence());
        parameters.addValue("instatus", (Object)webcontent.getStatus());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        Type type = new TypeToken<ObjectResponse<WebContent>>(){}.getType();
        ObjectResponse response = (ObjectResponse)new Gson().fromJson(json.getJson(), type);
        if (response.getStatus().equalsIgnoreCase("OK") && response.getData() != null && webcontent.getWebcontentassignment() != null) {
            webcontent.getWebcontentassignment().setWebcontentuuid(((WebContent)response.getData()).getWebcontentuuid());
            ObjectResponse<WebContentAssignment> wcaResponse = this.webcontentassignmentdao.postWebContetAssignment(token, webcontent.getWebcontentassignment());
            ((WebContent)response.getData()).setWebcontentassignment((WebContentAssignment)wcaResponse.getData());
        }
        return (WebContent)response.getData();
    }

    @Override
    public EmaiTemplateWebContent getByCompetitionSignup(Token token, UUID customeraccountuuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson from proc_view_competition_signup_emailtemplate(:token::t_pgpmessage,   :customeraccountuuid::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("customeraccountuuid", (Object)customeraccountuuid);
        JsonData jsondata = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)new RowMapper<JsonData>(){

            public JsonData mapRow(ResultSet rs, int rowNum) throws SQLException {
                JsonData json = new JsonData();
                json.setJson(rs.getString("outjson"));
                return json;
            }
        });
        EmaiTemplateWebContent email = PostgresqlJson.jsonRowToEmailTemplate((JsonData)jsondata);
        return email;
    }

    @Override
    public EmaiTemplateWebContent getByEventSignup(Token token, UUID customeraccountuuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson from proc_view_event_signup_emailtemplate(:token::t_pgpmessage,   :customeraccountuuid::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("customeraccountuuid", (Object)customeraccountuuid);
        JsonData jsondata = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)new RowMapper<JsonData>(){

            public JsonData mapRow(ResultSet rs, int rowNum) throws SQLException {
                JsonData json = new JsonData();
                json.setJson(rs.getString("outjson"));
                return json;
            }
        });
        EmaiTemplateWebContent email = PostgresqlJson.jsonRowToEmailTemplate((JsonData)jsondata);
        return email;
    }
}

