/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import javax.sql.DataSource;
import net.blugrid.core.dao.FileObjectDAO;
import net.blugrid.core.model.FileObject;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.ObjectResponse;
import net.blugrid.core.model.Token;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class FileObjectDAOImpl
implements FileObjectDAO {
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public ObjectResponse<FileObject> postFile(Token Token2, FileObject file) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS jsondata FROM proc_post_file (    :sessiontoken::t_pgpmessage,   :fileuuid::t_uuid,   :name::t_name,   :url::t_urladdress,   :filename::t_descriptionshort,   :partyuuid::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("sessiontoken", (Object)Token2.getid_token());
        parameters.addValue("fileuuid", (Object)file.getFileuuid());
        parameters.addValue("name", (Object)file.getName());
        parameters.addValue("url", (Object)file.getUrl());
        parameters.addValue("filename", (Object)file.getFilename());
        parameters.addValue("partyuuid", (Object)file.getCreator().getPartyuuid());
        JsonData jsondata = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        Type type = new TypeToken<ObjectResponse<FileObject>>(){}.getType();
        ObjectResponse response = (ObjectResponse)new Gson().fromJson(jsondata.getJson(), type);
        return response;
    }
}

