/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import net.blugrid.core.dao.ImageGalleryDAO;
import net.blugrid.core.model.ImageGallery;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.Response;
import net.blugrid.core.model.Token;
import net.blugrid.core.utils.PostgresqlJson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ImageGalleryDAOImpl
implements ImageGalleryDAO {
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public List<ImageGallery> getAll(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson from proc_view_imagegallery(   :token::t_pgpmessage,   NULL::t_uuid ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        List jsondata = namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new RowMapper<JsonData>(){

            public JsonData mapRow(ResultSet rs, int rowNum) throws SQLException {
                JsonData json = new JsonData();
                json.setJson(rs.getString("outjson"));
                return json;
            }
        });
        List response = PostgresqlJson.jsonListImageGalleryList((List)jsondata);
        return response;
    }

    @Override
    public Response post(Token Token2, ImageGallery imagegallery) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outstatus as status,   outsource as source,   outmessage as message  FROM proc_post_imagegallery(   :sessiontoken::t_pgpmessage,  :imagegalleryuuid::t_uuid,  :imagegalleryname::t_descriptionshort,   :description::t_description  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("sessiontoken", (Object)Token2.getid_token());
        parameters.addValue("imagegalleryuuid", (Object)imagegallery.getImagegalleryuuid());
        parameters.addValue("imagegalleryname", (Object)imagegallery.getImagegalleryname());
        parameters.addValue("description", (Object)imagegallery.getDescription());
        Response response = (Response)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(Response.class));
        return response;
    }
}

