/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import java.util.Date;
import java.util.UUID;
import javax.sql.DataSource;
import net.blugrid.core.dao.SessionDAO;
import net.blugrid.core.model.Client;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.SessionResponse;
import net.blugrid.core.model.Token;
import net.blugrid.core.utils.DateUtils;
import net.blugrid.core.utils.PostgresqlJson;
import net.blugrid.core.utils.TokenHandler;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class SessionDAOImpl
implements SessionDAO {
    private static final Logger logger = Logger.getLogger(SessionDAOImpl.class);
    @Autowired
    private TokenHandler Tokenhandler;
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public SessionResponse validateSession(Token token, String appkey, String ipaddress, Date localtime) {
        SessionResponse response = new SessionResponse();
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json FROM proc_check_session(   :insessiontoken::t_pgpmessage,   :inappkey::t_key,   :inipaddress::t_ipaddress,   :intimezoneoffset::t_code6 ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("insessiontoken", (Object)token.getid_token());
        parameters.addValue("inappkey", (Object)appkey);
        parameters.addValue("inipaddress", (Object)ipaddress);
        parameters.addValue("intimezoneoffset", (Object)DateUtils.getTimeZoneOffset((Date)localtime));
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        response = PostgresqlJson.jsonToSessionResponse((JsonData)json);
        response = this.Tokenhandler.setJjwtToken(response);
        return response;
    }

    @Override
    public SessionResponse postAnonymousSession(String appkey, String ipaddress, Date localtime) {
        SessionResponse response = new SessionResponse();
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json FROM proc_post_anonymous_session(   :inappkey::t_key,   :inipaddress::t_ipaddress,   :intimezoneoffset::t_code6 ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("inappkey", (Object)appkey);
        parameters.addValue("inipaddress", (Object)ipaddress);
        parameters.addValue("intimezoneoffset", (Object)DateUtils.getTimeZoneOffset((Date)localtime));
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        response = PostgresqlJson.jsonToSessionResponse((JsonData)json);
        logger.info((Object)("postAnonymousSession response: " + response.getStatus() + " " + response.getMessage()));
        response = this.Tokenhandler.setJjwtToken(response);
        return response;
    }

    @Override
    public SessionResponse postWebMailSession(UUID clientuuid, UUID messsageuuid, UUID trackinguuid, String ipaddress, String timezoneoffset) {
        SessionResponse response = new SessionResponse();
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json FROM proc_post_webmail_session(   :inclientuuid::t_uuid,   :inmessageuuid::t_uuid,   :intrackinguuid::t_uuid,   :inipaddress::t_ipaddress,   :intimezoneoffset::t_code6 ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("inclientuuid", (Object)clientuuid);
        parameters.addValue("inmessageuuid", (Object)messsageuuid);
        parameters.addValue("intrackinguuid", (Object)trackinguuid);
        parameters.addValue("inipaddress", (Object)ipaddress);
        parameters.addValue("intimezoneoffset", (Object)timezoneoffset);
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        response = PostgresqlJson.jsonToSessionResponse((JsonData)json);
        response = this.Tokenhandler.setJjwtToken(response);
        if (response.getSession() != null) {
            logger.info((Object)("postByTrackingUuid Session Token Created: " + response.getSession().getSessiontoken().getid_token()));
        } else {
            logger.error((Object)("postByTrackingUuid No Session Returned. " + response.getMessage()));
        }
        return response;
    }

    @Override
    public Client getClientID(Token token) {
        Client client = new Client();
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outclientid as clientid FROM Proc_lkp_sessiontoken(   :sessiontoken::t_pgpmessage ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("sessiontoken", (Object)token.getid_token());
        client = (Client)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(Client.class));
        return client;
    }
}

