/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.core.dao;

import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import net.blugrid.core.dao.TenderDAO;
import net.blugrid.core.model.JsonData;
import net.blugrid.core.model.Tender;
import net.blugrid.core.model.Token;
import net.blugrid.service.StripeApi;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class TenderDAOImpl
implements TenderDAO {
    @Autowired
    @Qualifier(value="dbDataSource")
    private DataSource dataSource;
    @Autowired
    private StripeApi Stripeapi;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public List<Tender> getAll(Token token) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_tender(    :token::t_pgpmessage,    NULL::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        List response = (List)new GsonBuilder().create().fromJson(json.getJson(), new ArrayList().getClass());
        return response;
    }

    @Override
    public Tender getByUUID(Token token, UUID uuid) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_view_tender(    :token::t_pgpmessage,    :intenderuuid::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("intenderuuid", (Object)uuid.toString());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        Tender response = (Tender)new GsonBuilder().create().fromJson(json.getJson(), Tender.class);
        return response;
    }

    @Override
    public Tender post(Token token, Tender tender) {
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        String sql = "SELECT outjson AS json from proc_post_tender(    :token::t_pgpmessage,    :intenderuuid::t_uuid,    :intendertype::t_tendertype,    :indescription::t_description,    :instatus::t_status,    :inpaymentprocessoraccountuuid::t_uuid  ) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("token", (Object)token.getid_token());
        parameters.addValue("intenderuuid", (Object)tender.getTenderuuid());
        parameters.addValue("intendertype", (Object)tender.getTendertype());
        parameters.addValue("indescription", (Object)tender.getDescription());
        parameters.addValue("instatus", (Object)tender.getStatus());
        parameters.addValue("inpaymentprocessoraccountuuid", (Object)tender.getPaymentprocessoraccountuuid());
        JsonData json = (JsonData)namedParameterJdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (RowMapper)BeanPropertyRowMapper.newInstance(JsonData.class));
        Tender response = (Tender)new GsonBuilder().create().fromJson(json.getJson(), Tender.class);
        return response;
    }
}

