/*
 * Decompiled with CFR 0.152.
 */
package net.bndy.ftsi;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bndy.ftsi.IndexStatus;
import net.bndy.ftsi.IndexType;
import net.bndy.ftsi.Indexable;
import net.bndy.ftsi.InvalidKeyTypeException;
import net.bndy.ftsi.NoKeyDefinedException;
import net.bndy.ftsi.SearchResult;
import net.bndy.lib.AnnotationHelper;
import net.bndy.lib.CollectionHelper;
import net.bndy.lib.IOHelper;
import net.bndy.lib.ReflectionHelper;
import net.bndy.lib.StringHelper;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.SimpleSpanFragmenter;
import org.apache.lucene.search.highlight.TokenSources;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class IndexService {
    private static final String DEFAULT_HIGHLIGHT_PRE_TAG = "<B class='highlight'>";
    private static final String DEFAULT_HIGHLIGHT_POST_TAG = "</B>";
    private static final int DEFAULT_HIGHLIGHT_FRAGMENT_SIZE = 100;
    private String dataPath;
    private Analyzer analyzer;
    private String highlightPreTag;
    private String highlightPostTag;
    private int highlightFragmentSize;

    public IndexService(String dataPath) {
        this(dataPath, (Analyzer)new StandardAnalyzer(), null, null, null);
    }

    public IndexService(String dataPath, Analyzer analyzer) {
        this(dataPath, analyzer, null, null, null);
    }

    public IndexService(String dataPath, String highlightPreTag, String highlightPostTag, int highlightFragmentSize) {
        this(dataPath, (Analyzer)new StandardAnalyzer(), highlightPreTag, highlightPostTag, highlightFragmentSize);
    }

    public IndexService(String dataPath, Analyzer analyzer, String highlightPreTag, String highlightPostTag, Integer highlightFragmentSize) {
        if (StringHelper.isNullOrWhiteSpace((String)dataPath)) {
            throw new IllegalArgumentException("The data path can not be empty.");
        }
        if (!IOHelper.isDirectoryExisted((String)dataPath)) {
            IOHelper.ensureDirectory((String)dataPath);
        }
        this.dataPath = dataPath;
        this.analyzer = analyzer == null ? new StandardAnalyzer() : analyzer;
        this.highlightPreTag = highlightPreTag == null ? DEFAULT_HIGHLIGHT_PRE_TAG : highlightPreTag;
        this.highlightPostTag = highlightPostTag == null ? DEFAULT_HIGHLIGHT_POST_TAG : highlightPostTag;
        this.highlightFragmentSize = highlightFragmentSize == null ? 100 : highlightFragmentSize;
    }

    public <T> IndexStatus status(Class<T> clazz) {
        DirectoryReader reader = this.getReader(clazz);
        IndexStatus indexStatus = new IndexStatus(reader.numDocs(), reader.numDeletedDocs(), reader.maxDoc());
        try {
            reader.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return indexStatus;
    }

    public <T> int getTotals(Class<T> clazz) {
        return this.getReader(clazz).numDocs();
    }

    public int getTotals() {
        int totals = 0;
        if (!StringHelper.isNullOrWhiteSpace((String)this.dataPath) && IOHelper.isDirectoryExisted((String)this.dataPath)) {
            List folders = IOHelper.getDirectories((String)this.dataPath);
            for (File file : folders) {
                totals += this.getReader(file.getName()).numDocs();
            }
        }
        return totals;
    }

    public void createIndex(Object ... items) {
        HashMap<String, IndexWriter> writers = new HashMap<String, IndexWriter>();
        try {
            for (Object item : items) {
                Field[] fields;
                IndexWriter writer = (IndexWriter)writers.get(item.getClass().getName());
                if (writer == null) {
                    writer = this.getWriter(item.getClass());
                    writers.put(item.getClass().getName(), writer);
                }
                Document doc = new Document();
                for (Field field : fields = item.getClass().getDeclaredFields()) {
                    Number val;
                    Indexable annotationIndexable;
                    field.setAccessible(true);
                    String fieldName = field.getName();
                    Type fieldType = field.getGenericType();
                    Object fieldValue = field.get(item);
                    if (fieldValue == null || (annotationIndexable = (Indexable)AnnotationHelper.getFieldAnnotation(Indexable.class, item.getClass(), (String)fieldName)) != null && annotationIndexable.ignore() && !annotationIndexable.isKey()) continue;
                    if (annotationIndexable != null && annotationIndexable.isKey()) {
                        if (field.getType() != String.class) {
                            throw new InvalidKeyTypeException(item.getClass());
                        }
                        doc.add((IndexableField)new StringField(fieldName, fieldValue.toString(), Field.Store.YES));
                        continue;
                    }
                    if (fieldType.equals(String.class)) {
                        if (annotationIndexable != null && annotationIndexable.stringIndexType() == IndexType.EXACT) {
                            doc.add((IndexableField)new StringField(fieldName, fieldValue.toString(), Field.Store.YES));
                            continue;
                        }
                        doc.add((IndexableField)new TextField(fieldName, fieldValue.toString(), Field.Store.YES));
                        continue;
                    }
                    if (fieldType.equals(Long.class) || fieldType.equals(Long.TYPE)) {
                        val = Long.parseLong(fieldValue.toString());
                        doc.add((IndexableField)new NumericDocValuesField(fieldName, ((Long)val).longValue()));
                        doc.add((IndexableField)new StoredField(fieldName, ((Long)val).longValue()));
                        doc.add((IndexableField)new LongPoint(fieldName, new long[]{(Long)val}));
                        continue;
                    }
                    if (fieldType.equals(Integer.class) || fieldType.equals(Integer.TYPE)) {
                        val = Integer.parseInt(fieldValue.toString());
                        doc.add((IndexableField)new NumericDocValuesField(fieldName, ((Integer)val).longValue()));
                        doc.add((IndexableField)new StoredField(fieldName, ((Integer)val).intValue()));
                        doc.add((IndexableField)new IntPoint(fieldName, new int[]{(Integer)val}));
                        continue;
                    }
                    if (fieldType.equals(Float.class) || fieldType.equals(Float.TYPE)) {
                        val = Float.valueOf(Float.parseFloat(fieldValue.toString()));
                        doc.add((IndexableField)new NumericDocValuesField(fieldName, ((Float)val).longValue()));
                        doc.add((IndexableField)new StoredField(fieldName, ((Float)val).floatValue()));
                        doc.add((IndexableField)new FloatPoint(fieldName, new float[]{((Float)val).floatValue()}));
                        continue;
                    }
                    if (fieldType.equals(Double.class) || fieldType.equals(Double.TYPE)) {
                        val = Double.parseDouble(fieldValue.toString());
                        doc.add((IndexableField)new NumericDocValuesField(fieldName, ((Double)val).longValue()));
                        doc.add((IndexableField)new StoredField(fieldName, ((Double)val).doubleValue()));
                        doc.add((IndexableField)new DoublePoint(fieldName, new double[]{(Double)val}));
                        continue;
                    }
                    doc.add((IndexableField)new StringField(fieldName, fieldValue.toString(), Field.Store.YES));
                }
                writer.addDocument((Iterable)doc);
            }
            for (IndexWriter writer : writers.values()) {
                writer.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void updateIndex(Object data) throws NoKeyDefinedException, IllegalAccessException {
        Field keyField = this.getKeyField(data.getClass());
        if (keyField == null) {
            throw new NoKeyDefinedException(data.getClass());
        }
        keyField.setAccessible(true);
        this.deleteIndex(data.getClass(), keyField.get(data));
        this.createIndex(data);
    }

    public <T> long deleteIndex(Class<T> clazz, Object keyValue) throws NoKeyDefinedException {
        if (keyValue == null || "".equals(keyValue.toString())) {
            return 0L;
        }
        long result = 0L;
        try {
            Field[] fields;
            boolean hasKeyDefinition = false;
            IndexWriter writer = this.getWriter(clazz);
            for (Field field : fields = clazz.getDeclaredFields()) {
                Indexable indexable = (Indexable)AnnotationHelper.getFieldAnnotation(Indexable.class, clazz, (String)field.getName());
                if (indexable == null || !indexable.isKey()) continue;
                hasKeyDefinition = true;
                Term term = new Term(field.getName(), keyValue.toString());
                result = writer.deleteDocuments(new Term[]{term});
                break;
            }
            if (!hasKeyDefinition) {
                throw new NoKeyDefinedException(clazz);
            }
            writer.forceMergeDeletes();
            writer.close();
            return result;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return result;
        }
    }

    public <T> SearchResult<T> search(String fieldName, String fieldValue, Class<T> targetClass, int page, int pageSize) {
        if (page < 1) {
            page = 1;
        }
        if (pageSize < 1) {
            pageSize = 10;
        }
        ArrayList<T> items = new ArrayList<T>();
        DirectoryReader reader = this.getReader(targetClass);
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        TermQuery query = new TermQuery(new Term(fieldName, fieldValue));
        Highlighter highlighter = this.getHighlighter((Query)query);
        try {
            TopDocs topDocs = searcher.search((Query)query, page * pageSize);
            ScoreDoc[] scoreDocs = topDocs.scoreDocs;
            for (int i = (page - 1) * pageSize; i < page * pageSize && i < scoreDocs.length; ++i) {
                int docId = scoreDocs[i].doc;
                items.add(this.doc2Entity(docId, searcher.doc(docId), targetClass, highlighter, (IndexReader)reader));
            }
            reader.close();
            return new SearchResult(page, pageSize, topDocs.totalHits > (long)(page * pageSize), items);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public <T> SearchResult<T> search(String keywords, Class<T> targetClass, int page, int pageSize) {
        return this.search(keywords, targetClass, null, page, pageSize);
    }

    public <T> SearchResult<T> search(String keywords, Class<T> targetClass, Map<String, Object> andCondition, int page, int pageSize) {
        if (page < 1) {
            page = 1;
        }
        if (pageSize < 1) {
            pageSize = 10;
        }
        List<String> lstFields = this.getIndexableFields(targetClass);
        ArrayList<BooleanClause.Occur> lstOccurs = new ArrayList<BooleanClause.Occur>();
        for (String field : lstFields) {
            lstOccurs.add(BooleanClause.Occur.SHOULD);
        }
        try {
            Query multiFieldQuery = MultiFieldQueryParser.parse((String)keywords, (String[])lstFields.toArray(new String[lstFields.size()]), (BooleanClause.Occur[])lstOccurs.toArray(new BooleanClause.Occur[lstOccurs.size()]), (Analyzer)this.analyzer);
            BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
            queryBuilder.add(multiFieldQuery, BooleanClause.Occur.SHOULD);
            if (andCondition != null) {
                for (String key : andCondition.keySet()) {
                    if (andCondition.get(key) == null) continue;
                    TermQuery termQuery = new TermQuery(new Term(key, andCondition.get(key).toString()));
                    queryBuilder.add((Query)termQuery, BooleanClause.Occur.MUST);
                }
            }
            BooleanQuery query = queryBuilder.build();
            ArrayList<T> items = new ArrayList<T>();
            DirectoryReader reader = this.getReader(targetClass);
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            TopDocs topDocs = searcher.search((Query)query, page * pageSize);
            ScoreDoc[] scoreDocs = topDocs.scoreDocs;
            Highlighter highlighter = this.getHighlighter((Query)query);
            for (int i = (page - 1) * pageSize; i < page * pageSize && i < scoreDocs.length; ++i) {
                int docId = scoreDocs[i].doc;
                items.add(this.doc2Entity(docId, searcher.doc(docId), targetClass, highlighter, (IndexReader)reader));
            }
            reader.close();
            return new SearchResult(page, pageSize, topDocs.totalHits > (long)(page * pageSize), items);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        catch (IllegalStateException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public <T> void deleteAll(Class<T> targetClass) {
        IndexWriter writer = this.getWriter(targetClass);
        try {
            writer.deleteAll();
            writer.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void deleteAll() {
        if (!StringHelper.isNullOrWhiteSpace((String)this.dataPath) && IOHelper.isDirectoryExisted((String)this.dataPath)) {
            List folders = IOHelper.getDirectories((String)this.dataPath);
            for (File file : folders) {
                IndexWriter writer = this.getWriter(file.getName());
                try {
                    writer.deleteAll();
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private <T> Directory getCatalogDirectory(Class<T> targetClass) throws IOException {
        return this.getCatalogDirectory(targetClass.getName());
    }

    private <T> Directory getCatalogDirectory(String catalog) throws IOException {
        Path path = Paths.get(this.dataPath, catalog);
        return FSDirectory.open((Path)path);
    }

    private <T> IndexWriter getWriter(Class<T> targetClass) {
        return this.getWriter(targetClass.getName());
    }

    private IndexWriter getWriter(String catalog) {
        try {
            IndexWriterConfig config = this.getIndexWriterConfig();
            config.setCommitOnClose(true);
            return new IndexWriter(this.getCatalogDirectory(catalog), config);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private <T> DirectoryReader getReader(Class<T> targetClass) {
        return this.getReader(targetClass.getName());
    }

    private DirectoryReader getReader(String catalog) {
        try {
            return DirectoryReader.open((Directory)this.getCatalogDirectory(catalog));
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private List<String> getIndexableFields(Class<?> clazz) {
        return CollectionHelper.convert((Collection)CollectionHelper.filter((Collection)ReflectionHelper.getAllFields(clazz), f -> {
            Indexable indexable = (Indexable)AnnotationHelper.getFieldAnnotation(Indexable.class, (Class)clazz, (String)f.getName());
            return indexable == null || !indexable.ignore();
        }), filed -> filed.getName());
    }

    private <T> T doc2Entity(int docId, Document doc, Class<T> targetClass, Highlighter highlighter, IndexReader reader) {
        try {
            return (T)CollectionHelper.convertMap2(this.doc2Map(docId, doc, highlighter, reader), targetClass);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private Map<String, Object> doc2Map(int docId, Document doc, Highlighter highlighter, IndexReader reader) {
        List documentFields = doc.getFields();
        HashMap<String, Object> fieldMapping = new HashMap<String, Object>();
        for (IndexableField documentField : documentFields) {
            if (documentField.numericValue() != null) {
                fieldMapping.put(documentField.name(), documentField.numericValue());
                continue;
            }
            String fieldValue = documentField.stringValue();
            if (highlighter != null) {
                try {
                    TokenStream tokenStream = TokenSources.getTokenStream((String)documentField.name(), (Fields)reader.getTermVectors(docId), (String)fieldValue, (Analyzer)this.analyzer, (int)-1);
                    String fragment = highlighter.getBestFragment(tokenStream, fieldValue);
                    if (fragment != null) {
                        fieldValue = fragment;
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                catch (InvalidTokenOffsetsException ex) {
                    ex.printStackTrace();
                }
            }
            fieldMapping.put(documentField.name(), fieldValue);
        }
        return fieldMapping;
    }

    private <T> Field getKeyField(Class<T> clazz) {
        return (Field)CollectionHelper.first((Collection)CollectionHelper.array2List((Object[])clazz.getDeclaredFields()), field -> {
            Indexable indexable = (Indexable)AnnotationHelper.getFieldAnnotation(Indexable.class, (Class)clazz, (String)field.getName());
            return indexable != null && indexable.isKey();
        });
    }

    private IndexWriterConfig getIndexWriterConfig() {
        return new IndexWriterConfig(this.analyzer);
    }

    private Highlighter getHighlighter(Query query) {
        if (this.highlightPreTag == null || this.highlightPostTag == null) {
            return null;
        }
        QueryScorer scorer = new QueryScorer(query);
        SimpleHTMLFormatter formatter = new SimpleHTMLFormatter(this.highlightPreTag, this.highlightPostTag);
        Highlighter highlighter = new Highlighter((Formatter)formatter, (Scorer)scorer);
        SimpleSpanFragmenter fragmenter = new SimpleSpanFragmenter(scorer, this.highlightFragmentSize);
        highlighter.setTextFragmenter((Fragmenter)fragmenter);
        return highlighter;
    }
}

