/*
 * Decompiled with CFR 0.152.
 */
package net.bndy.lib.data;

import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.JpaRepository;

public abstract class JpaService<TEntity, TKey> {
    protected Class<TEntity> entityClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    @Autowired
    JpaRepository<TEntity, TKey> repository;

    public List<TEntity> getAll() {
        return this.repository.findAll();
    }

    public List<TEntity> getAll(Sort sort) {
        return this.repository.findAll(sort);
    }

    public TEntity get(TKey id) {
        Optional opt = this.repository.findById(id);
        if (opt.isPresent()) {
            return (TEntity)opt.get();
        }
        return null;
    }

    public List<TEntity> get(Iterable<TKey> ids) {
        return this.repository.findAllById(ids);
    }

    public void delete(TKey id) {
        this.repository.deleteById(id);
    }

    public TEntity save(TEntity entity) {
        return (TEntity)this.repository.saveAndFlush(entity);
    }

    public List<TEntity> saveAll(Iterable<TEntity> entities) {
        return this.repository.saveAll(entities);
    }

    public Page<TEntity> findAll(Pageable pageable) {
        return this.repository.findAll(pageable);
    }
}

