/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.cache.guava;

import com.google.common.cache.CacheBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.bolbat.kit.cache.Cache;
import net.bolbat.kit.cache.LoadFunction;
import org.configureme.annotations.AfterConfiguration;
import org.configureme.annotations.Configure;
import org.configureme.annotations.ConfigureMe;

@ConfigureMe(allfields=false)
public class GuavaCache<K, V>
implements Cache<K, V> {
    private com.google.common.cache.Cache<K, V> originalCache;
    @Configure
    private int initialCapacity;
    @Configure
    private long maximumCapacity;
    @Configure
    private Long expireAfterAccess;
    @Configure
    private TimeUnit expireAfterAccessTimeUnit;
    @Configure
    private Long expireAfterWrite;
    @Configure
    private TimeUnit expireAfterWriteTimeUnit;
    private LoadFunction<K, V> functionLoad;

    protected GuavaCache(int aInitialCapacity, long aMaximumCapacity, Long aExpireAfterAccess, TimeUnit aExpireAfterAccessTimeUnit, Long aExpireAfterWrite, TimeUnit aExpireAfterWriteTimeUnit, LoadFunction<K, V> aFunctionLoad, boolean skipConfiguration) {
        this.initialCapacity = aInitialCapacity;
        this.maximumCapacity = aMaximumCapacity;
        this.expireAfterAccess = aExpireAfterAccess;
        this.expireAfterAccessTimeUnit = aExpireAfterAccessTimeUnit;
        this.expireAfterWrite = aExpireAfterWrite;
        this.expireAfterWriteTimeUnit = aExpireAfterWriteTimeUnit;
        this.functionLoad = aFunctionLoad;
        if (!skipConfiguration) {
            this.configureCache();
        }
    }

    public void setOriginalCache(com.google.common.cache.Cache<K, V> originalCache) {
        this.originalCache = originalCache;
    }

    public void setInitialCapacity(int aInitialCapacity) {
        this.initialCapacity = aInitialCapacity;
    }

    @Deprecated
    public void setInitiateCapacity(int aInitialCapacity) {
        this.setInitialCapacity(aInitialCapacity);
    }

    public void setMaximumCapacity(long maximumCapacity) {
        this.maximumCapacity = maximumCapacity;
    }

    public void setExpireAfterAccess(Long expireAfterAccess) {
        this.expireAfterAccess = expireAfterAccess;
    }

    public void setExpireAfterAccessTimeUnit(TimeUnit expireAfterAccessTimeUnit) {
        this.expireAfterAccessTimeUnit = expireAfterAccessTimeUnit;
    }

    public void setExpireAfterWrite(Long expireAfterWrite) {
        this.expireAfterWrite = expireAfterWrite;
    }

    public void setExpireAfterWriteTimeUnit(TimeUnit expireAfterWriteTimeUnit) {
        this.expireAfterWriteTimeUnit = expireAfterWriteTimeUnit;
    }

    @AfterConfiguration
    public void configureCache() {
        HashMap oldCache = null;
        if (this.originalCache != null && this.originalCache.size() > 0L) {
            oldCache = new HashMap(this.originalCache.asMap());
        }
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (this.initialCapacity > 0) {
            cacheBuilder.initialCapacity(this.initialCapacity);
        }
        if (this.maximumCapacity > 0L) {
            cacheBuilder.maximumSize(this.maximumCapacity);
        }
        if (this.expireAfterAccess != null) {
            cacheBuilder.expireAfterAccess(this.expireAfterAccess.longValue(), this.expireAfterAccessTimeUnit);
        }
        if (this.expireAfterWrite != null) {
            cacheBuilder.expireAfterWrite(this.expireAfterWrite.longValue(), this.expireAfterWriteTimeUnit);
        }
        this.originalCache = cacheBuilder.build();
        if (oldCache != null) {
            this.originalCache.putAll(oldCache);
        }
    }

    @Override
    public V get(K key) {
        Object result = this.originalCache.getIfPresent(key);
        if (this.functionLoad != null && result == null && (result = this.functionLoad.load(key)) != null) {
            this.put(key, result);
        }
        return (V)result;
    }

    @Override
    public void put(K key, V value) {
        this.originalCache.put(key, value);
    }

    @Override
    public void invalidate(K key) {
        this.originalCache.invalidate(key);
    }

    @Override
    public Collection<V> get(Iterable<? extends K> keys) {
        return this.originalCache.getAllPresent(keys).values();
    }

    @Override
    public Collection<V> getAll() {
        return this.originalCache.asMap().values();
    }

    @Override
    public Map<K, V> getAllAsMap() {
        return this.originalCache.asMap();
    }

    @Override
    public void put(Map<K, V> elements) {
        this.originalCache.putAll(elements);
    }

    @Override
    public void invalidate(Iterable<? extends K> keys) {
        this.originalCache.invalidateAll(keys);
    }

    @Override
    public void invalidateAll() {
        this.originalCache.invalidateAll();
    }

    @Override
    public long size() {
        return this.originalCache.size();
    }

    @Override
    public void cleanUp() {
        this.originalCache.cleanUp();
    }

    @Override
    public boolean isEmpty() {
        return this.originalCache == null || this.originalCache.size() == 0L;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("[originalCache=").append(this.originalCache);
        sb.append(", initialCapacity=").append(this.initialCapacity);
        sb.append(", maximumCapacity=").append(this.maximumCapacity);
        sb.append(", expireAfterAccess=").append(this.expireAfterAccess);
        sb.append(", expireAfterAccessTimeUnit=").append((Object)this.expireAfterAccessTimeUnit);
        sb.append(", expireAfterWrite=").append(this.expireAfterWrite);
        sb.append(", expireAfterWriteTimeUnit=").append((Object)this.expireAfterWriteTimeUnit);
        sb.append(", functionLoad=").append(this.functionLoad);
        sb.append(']');
        return sb.toString();
    }
}

