/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.cache.guava;

import java.util.concurrent.TimeUnit;
import net.bolbat.kit.cache.Cache;
import net.bolbat.kit.cache.CacheBuilder;
import net.bolbat.kit.cache.LoadFunction;
import net.bolbat.kit.cache.guava.GuavaCache;
import net.bolbat.utils.lang.StringUtils;
import org.configureme.ConfigurationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuavaCacheBuilder<K, V>
implements CacheBuilder<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GuavaCacheBuilder.class);
    private int initialCapacity;
    private long maximumCapacity;
    private Long expireAfterAccess;
    private TimeUnit expireAfterAccessTimeUnit;
    private Long expireAfterWrite;
    private TimeUnit expireAfterWriteTimeUnit;
    private LoadFunction<K, V> functionLoad;

    public GuavaCacheBuilder<K, V> initialCapacity(int aInitialCapacity) {
        this.initialCapacity = aInitialCapacity;
        return this;
    }

    @Deprecated
    public GuavaCacheBuilder<K, V> initiateCapacity(int aInitialCapacity) {
        return this.initialCapacity(aInitialCapacity);
    }

    public GuavaCacheBuilder<K, V> maximumCapacity(long aMaximumCapacity) {
        this.maximumCapacity = aMaximumCapacity;
        return this;
    }

    public GuavaCacheBuilder<K, V> expireAfterAccess(Long aExpireAfterAccess) {
        this.expireAfterAccess = aExpireAfterAccess;
        return this;
    }

    public GuavaCacheBuilder<K, V> expireAfterAccessTimeUnit(TimeUnit aExpireAfterAccessTimeUnit) {
        this.expireAfterAccessTimeUnit = aExpireAfterAccessTimeUnit;
        return this;
    }

    public GuavaCacheBuilder<K, V> expireAfterWrite(Long aExpireAfterWrite) {
        this.expireAfterWrite = aExpireAfterWrite;
        return this;
    }

    public GuavaCacheBuilder<K, V> expireAfterWriteTimeUnit(TimeUnit aExpireAfterWriteTimeUnit) {
        this.expireAfterWriteTimeUnit = aExpireAfterWriteTimeUnit;
        return this;
    }

    public GuavaCacheBuilder<K, V> functionLoad(LoadFunction<K, V> aFunctionLoad) {
        this.functionLoad = aFunctionLoad;
        return this;
    }

    @Override
    public Cache<K, V> build() {
        return this.build(false);
    }

    private GuavaCache<K, V> build(boolean skipConfiguration) {
        return new GuavaCache<K, V>(this.initialCapacity, this.maximumCapacity, this.expireAfterAccess, this.expireAfterAccessTimeUnit, this.expireAfterWrite, this.expireAfterWriteTimeUnit, this.functionLoad, skipConfiguration);
    }

    @Override
    public Cache<K, V> build(String configuration) {
        GuavaCache<K, V> cache = this.build(true);
        if (StringUtils.isEmpty((String)configuration)) {
            cache.configureCache();
            return cache;
        }
        try {
            ConfigurationManager.INSTANCE.configureAs(cache, configuration);
        }
        catch (RuntimeException e) {
            LOGGER.warn("build(" + configuration + ") fail. Can't configure cache[" + cache + "], skipping.");
            cache.configureCache();
        }
        return cache;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("[initialCapacity=").append(this.initialCapacity);
        sb.append(", maximumCapacity=").append(this.maximumCapacity);
        sb.append(", expireAfterAccess=").append(this.expireAfterAccess);
        sb.append(", expireAfterAccessTimeUnit=").append((Object)this.expireAfterAccessTimeUnit);
        sb.append(", expireAfterWrite=").append(this.expireAfterWrite);
        sb.append(", expireAfterWriteTimeUnit=").append((Object)this.expireAfterWriteTimeUnit);
        sb.append(", functionLoad=").append(this.functionLoad);
        sb.append(']');
        return sb.toString();
    }
}

