/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.config;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.bolbat.kit.config.Configuration;
import net.bolbat.kit.config.ConfigurationListener;
import org.configureme.annotations.DontConfigure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfiguration
implements Configuration {
    @DontConfigure
    private static final long serialVersionUID = -8251774226206047496L;
    @DontConfigure
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractConfiguration.class);
    @DontConfigure
    private final transient List<ConfigurationListener> listeners = new CopyOnWriteArrayList<ConfigurationListener>();

    public List<ConfigurationListener> getListeners() {
        return new ArrayList<ConfigurationListener>(this.listeners);
    }

    public void registerListener(ConfigurationListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void unregisterListener(ConfigurationListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public void unregisterListeners() {
        this.listeners.clear();
    }

    protected void fireConfigurationChanged() {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (ConfigurationListener listener : this.listeners) {
            if (listener == null) continue;
            try {
                listener.configurationChanged();
            }
            catch (RuntimeException e) {
                String cName = this.getClass().getName();
                String lName = listener.getClass().getName();
                LOGGER.warn("Configuration[" + cName + "] 'configurationChanged' event for listener[" + lName + "] fail.", (Throwable)e);
            }
        }
    }
}

