/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.config;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.bolbat.kit.config.ConfigurationRuntimeException;
import net.bolbat.utils.lang.StringUtils;
import net.bolbat.utils.reflect.ClassUtils;
import org.configureme.Environment;
import org.configureme.annotations.AfterConfiguration;
import org.configureme.annotations.AfterInitialConfiguration;
import org.configureme.environments.DynamicEnvironment;
import org.configureme.sources.ConfigurationSourceKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationManager {
    public static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationManager.class);
    private static final Map<Key<?>, Object> STORAGE = new ConcurrentHashMap();
    private static final Object LOCK = new Object();

    private ConfigurationManager() {
        throw new IllegalAccessError("Can't instantiate.");
    }

    public static <T> T getInstance(Class<T> type) {
        return ConfigurationManager.getInstance(type, null, null);
    }

    public static <T> T getInstanceForConf(Class<T> type, String name) {
        return ConfigurationManager.getInstance(type, name, null);
    }

    public static <T> T getInstanceForEnv(Class<T> type, String environment) {
        return ConfigurationManager.getInstance(type, null, environment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getInstance(Class<T> type, String name, String environment) {
        if (type == null) {
            throw new IllegalArgumentException("type argument is null");
        }
        Key<T> key = Key.create(type, name, environment);
        Object instance = STORAGE.get(key);
        if (instance != null) {
            return type.cast(instance);
        }
        Object object = LOCK;
        synchronized (object) {
            instance = STORAGE.get(key);
            if (instance != null) {
                return type.cast(instance);
            }
            try {
                org.configureme.ConfigurationManager cm = org.configureme.ConfigurationManager.INSTANCE;
                Environment env = environment != null ? DynamicEnvironment.parse((String)environment) : cm.getDefaultEnvironment();
                instance = type.newInstance();
                if (StringUtils.isNotEmpty((String)name)) {
                    cm.configureAs(instance, env, name, ConfigurationSourceKey.Format.JSON);
                } else {
                    cm.configure(instance, env, ConfigurationSourceKey.Format.JSON);
                }
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (ConfigurationRuntimeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                ConfigurationManager.relayOnDefaults(instance, e.getMessage());
            }
            STORAGE.put(key, instance);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Configured with[" + instance + "]");
            }
        }
        return type.cast(instance);
    }

    private static void relayOnDefaults(Object instance, String cause) {
        LOGGER.warn("Configuration fail[" + cause + "]. Relaying on defaults.");
        ClassUtils.execute((Object)instance, (Class[])new Class[]{AfterConfiguration.class, AfterInitialConfiguration.class});
    }

    public static void tearDown() {
        STORAGE.clear();
    }

    private static class Key<T>
    implements Serializable {
        private static final long serialVersionUID = -1030330103453083666L;
        public static final String DELIMITER = "|";
        public static final String DEFAULT_NAME = "^";
        public static final String CURRENT_ENV = "^";
        private final Class<T> type;
        private final String name;
        private final String environment;

        private Key(Class<T> aType, String aName, String aEnvironment) {
            if (aType == null) {
                throw new IllegalArgumentException("aType argument is null");
            }
            this.type = aType;
            this.name = StringUtils.isNotEmpty((String)aName) ? aName : "^";
            this.environment = StringUtils.isNotEmpty((String)aEnvironment) ? aEnvironment : "^";
        }

        public static <T> Key<T> create(Class<T> aType, String aName, String aEnvironment) {
            return new Key<T>(aType, aName, aEnvironment);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.type.getName().hashCode();
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.environment.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            return this.type.getName().equals(other.type.getName()) && this.name.equals(other.name) && this.environment.equals(other.environment);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
            builder.append("[");
            builder.append(this.type.getName());
            builder.append(DELIMITER);
            builder.append(this.name);
            builder.append(DELIMITER);
            builder.append(this.environment);
            builder.append("]");
            return builder.toString();
        }
    }
}

