/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.event.common;

import java.io.Serializable;

public class EntitySavedEvent<Saved extends Serializable>
implements Serializable {
    private static final long serialVersionUID = 8380601278511664596L;
    private final Saved oldEntity;
    private final Saved newEntity;

    protected EntitySavedEvent(Saved oldEntity, Saved newEntity) {
        if (newEntity == null) {
            throw new IllegalArgumentException("newEntity is null");
        }
        this.oldEntity = oldEntity;
        this.newEntity = newEntity;
    }

    protected EntitySavedEvent(Saved newEntity) {
        this(null, newEntity);
    }

    public Saved getOldEntity() {
        return this.oldEntity;
    }

    public Saved getNewEntity() {
        return this.newEntity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntitySavedEvent that = (EntitySavedEvent)o;
        if (this.newEntity != null ? !this.newEntity.equals(that.newEntity) : that.newEntity != null) {
            return false;
        }
        return !(this.oldEntity != null ? !this.oldEntity.equals(that.oldEntity) : that.oldEntity != null);
    }

    public int hashCode() {
        int result = this.oldEntity != null ? this.oldEntity.hashCode() : 0;
        int multiplier = 31;
        result = 31 * result + (this.newEntity != null ? this.newEntity.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("[oldEntity=").append(this.oldEntity);
        sb.append(", newEntity=").append(this.newEntity);
        sb.append(']');
        return sb.toString();
    }
}

