/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.event.common;

import java.io.Serializable;

public class EntityUpdatedEvent<Updated extends Serializable>
implements Serializable {
    private static final long serialVersionUID = 6998272145202196761L;
    private final Updated oldEntity;
    private final Updated newEntity;

    protected EntityUpdatedEvent(Updated oldEntity, Updated newEntity) {
        if (oldEntity == null) {
            throw new IllegalArgumentException("oldEntity is null");
        }
        if (newEntity == null) {
            throw new IllegalArgumentException("newEntity is null");
        }
        this.oldEntity = oldEntity;
        this.newEntity = newEntity;
    }

    public Updated getOldEntity() {
        return this.oldEntity;
    }

    public Updated getNewEntity() {
        return this.newEntity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityUpdatedEvent that = (EntityUpdatedEvent)o;
        if (this.newEntity != null ? !this.newEntity.equals(that.newEntity) : that.newEntity != null) {
            return false;
        }
        return !(this.oldEntity != null ? !this.oldEntity.equals(that.oldEntity) : that.oldEntity != null);
    }

    public int hashCode() {
        int multiplier = 31;
        int result = this.oldEntity != null ? this.oldEntity.hashCode() : 0;
        result = 31 * result + (this.newEntity != null ? this.newEntity.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("[oldEntity=").append(this.oldEntity);
        sb.append(", newEntity=").append(this.newEntity);
        sb.append(']');
        return sb.toString();
    }
}

