/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.event.guava;

import com.google.common.eventbus.EventBus;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.bolbat.utils.lang.StringUtils;

public final class EventBusManager {
    public static final String DEFAULT_NAME = UUID.randomUUID().toString();
    private static final Map<String, EventBus> STORAGE = new ConcurrentHashMap<String, EventBus>();
    private static final Object LOCK = new Object();

    private EventBusManager() {
        throw new IllegalAccessError("Shouldn't be instantiated.");
    }

    public static EventBus getEventBus() {
        return EventBusManager.getEventBus(DEFAULT_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EventBus getEventBus(String name) {
        String busName = StringUtils.isNotEmpty((String)name) ? name : DEFAULT_NAME;
        EventBus bus = STORAGE.get(busName);
        if (bus != null) {
            return bus;
        }
        Object object = LOCK;
        synchronized (object) {
            bus = STORAGE.get(busName);
            if (bus != null) {
                return bus;
            }
            bus = new EventBus(busName);
            STORAGE.put(busName, bus);
            return bus;
        }
    }

    public static void tearDown() {
        STORAGE.clear();
    }
}

