/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.ioc;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.bolbat.kit.Module;
import net.bolbat.kit.ioc.ManagerException;
import net.bolbat.kit.ioc.ManagerModule;
import net.bolbat.kit.ioc.scope.CustomScope;
import net.bolbat.kit.ioc.scope.Scope;
import net.bolbat.kit.service.Configuration;
import net.bolbat.kit.service.Service;
import net.bolbat.kit.service.ServiceFactory;
import net.bolbat.utils.annotation.Stability;
import net.bolbat.utils.concurrency.lock.ConcurrentIdBasedLockManager;
import net.bolbat.utils.concurrency.lock.IdBasedLock;
import net.bolbat.utils.concurrency.lock.IdBasedLockManager;
import net.bolbat.utils.lang.StringUtils;
import net.bolbat.utils.lang.Validations;

@Stability.Stable
public final class Manager
implements Module {
    public static final Scope DEFAULT_SCOPE = CustomScope.get("SYSTEM_DEFAULT_SCOPE");
    public static final String DEFAULT_MODULE = "DEFAULT";
    private static final ConcurrentMap<String, ManagerModule> MODULES = new ConcurrentHashMap<String, ManagerModule>();
    private static final IdBasedLockManager<String> LOCK_MANAGER = new ConcurrentIdBasedLockManager();

    private Manager() {
        throw new IllegalAccessError("Can't instantiate.");
    }

    public static ManagerModule defaultModule() {
        return Manager.moduleInternally(DEFAULT_MODULE);
    }

    public static ManagerModule module(String name) {
        Validations.checkArgument((boolean)StringUtils.isNotEmpty((String)name), (Object)"name argument is empty");
        return Manager.moduleInternally(name);
    }

    private static ManagerModule moduleInternally(String name) {
        ManagerModule defaultModule = (ManagerModule)MODULES.get(name);
        if (defaultModule == null) {
            IdBasedLock lock = LOCK_MANAGER.obtainLock((Object)name);
            lock.lock();
            try {
                defaultModule = (ManagerModule)MODULES.get(name);
                if (defaultModule == null) {
                    defaultModule = new ManagerModule();
                    MODULES.put(name, defaultModule);
                }
            }
            finally {
                lock.unlock();
            }
        }
        return defaultModule;
    }

    public static <S extends Service> void link(Class<S> service, Scope target) {
        Manager.defaultModule().links().link(service, target);
    }

    public static <S extends Service> void link(Class<S> service, Scope source, Scope target) {
        Manager.defaultModule().links().link(service, source, target);
    }

    public static <S extends Service, SF extends ServiceFactory<S>> void register(Class<S> service, Class<SF> factory) {
        Manager.defaultModule().services().register(service, factory);
    }

    public static <S extends Service, SF extends ServiceFactory<S>> void register(Class<S> service, Class<SF> factory, Scope ... scopes) {
        Manager.defaultModule().services().register(service, factory, scopes);
    }

    public static <S extends Service, SF extends ServiceFactory<S>> void register(Class<S> service, Class<SF> factory, Configuration conf) {
        Manager.defaultModule().services().register(service, factory, conf);
    }

    public static <S extends Service, SF extends ServiceFactory<S>> void register(Class<S> service, Class<SF> factory, Configuration conf, Scope ... scopes) {
        Manager.defaultModule().services().register(service, factory, conf, scopes);
    }

    public static <S extends Service, SF extends ServiceFactory<S>> void register(Class<S> service, SF factory) {
        Manager.defaultModule().services().register(service, factory);
    }

    public static <S extends Service, SF extends ServiceFactory<S>> void register(Class<S> service, SF factory, Scope ... scopes) {
        Manager.defaultModule().services().register(service, factory, scopes);
    }

    public static <S extends Service, SF extends ServiceFactory<S>> void register(Class<S> service, SF factory, Configuration conf) {
        Manager.defaultModule().services().register(service, factory, conf);
    }

    public static <S extends Service, SF extends ServiceFactory<S>> void register(Class<S> service, SF factory, Configuration conf, Scope ... scopes) {
        Manager.defaultModule().services().register(service, factory, conf, scopes);
    }

    public static <S extends Service> void register(Class<S> service, S instance) {
        Manager.defaultModule().services().register(service, instance);
    }

    public static <S extends Service> void register(Class<S> service, S instance, Scope ... scopes) {
        Manager.defaultModule().services().register(service, instance, scopes);
    }

    public static <S extends Service> S getFast(Class<S> service, Scope ... scopes) {
        return Manager.defaultModule().getFast(service, scopes);
    }

    public static <S extends Service> S get(Class<S> service, Scope ... scopes) throws ManagerException {
        return Manager.defaultModule().get(service, scopes);
    }

    public static <S extends Service> boolean isRegistered(Class<S> service, Scope ... scopes) {
        return Manager.defaultModule().isRegistered(service, scopes);
    }

    public static void warmUp() {
        Manager.defaultModule().warmUp();
    }

    public static <S extends Service> void warmUp(Class<S> service) {
        Manager.defaultModule().warmUp(service);
    }

    public static void tearDown() {
        Manager.defaultModule().tearDown();
    }

    public static <S extends Service> void tearDown(Class<S> service) {
        Manager.defaultModule().tearDown(service);
    }

    public static enum Feature {
        AUTO_IMPL_DISCOVERY(true);

        private final boolean enabledByDefault;

        private Feature(boolean aEnabledByDefault) {
            this.enabledByDefault = aEnabledByDefault;
        }

        public boolean isEnabledByDefault() {
            return this.enabledByDefault;
        }
    }

    public static class Features {
        public static void enable(Feature ... toEnable) {
            Manager.defaultModule().features().enable(toEnable);
        }

        public static void disable(Feature ... toDisable) {
            Manager.defaultModule().features().disable(toDisable);
        }

        public static boolean isEnabled(Feature feature) {
            return Manager.defaultModule().features().isEnabled(feature);
        }
    }
}

