/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.ioc;

import java.util.ArrayList;
import net.bolbat.kit.Module;
import net.bolbat.kit.ioc.ConfigurationNotFoundException;
import net.bolbat.kit.ioc.Manager;
import net.bolbat.kit.ioc.ManagerException;
import net.bolbat.kit.ioc.ManagerRuntimeException;
import net.bolbat.kit.ioc.ManagerUtils;
import net.bolbat.kit.ioc.features.Features;
import net.bolbat.kit.ioc.features.FeaturesImpl;
import net.bolbat.kit.ioc.links.LinksRegistry;
import net.bolbat.kit.ioc.links.LinksRegistryImpl;
import net.bolbat.kit.ioc.scope.Scope;
import net.bolbat.kit.ioc.scope.ScopeUtil;
import net.bolbat.kit.ioc.services.ServiceConfiguration;
import net.bolbat.kit.ioc.services.ServicesRegistry;
import net.bolbat.kit.ioc.services.ServicesRegistryImpl;
import net.bolbat.kit.service.Configuration;
import net.bolbat.kit.service.DynamicServiceFactory;
import net.bolbat.kit.service.Service;
import net.bolbat.kit.service.ServiceFactory;
import net.bolbat.utils.annotation.Stability;
import net.bolbat.utils.lang.CastUtils;
import net.bolbat.utils.lang.ToStringUtils;
import net.bolbat.utils.lang.Validations;
import net.bolbat.utils.logging.LoggingUtils;
import net.bolbat.utils.reflect.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stability.Stable
public final class ManagerModule
implements Module {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagerModule.class);
    private final Object lock = new Object();
    private final Features features = new FeaturesImpl();
    private final ServicesRegistry services = new ServicesRegistryImpl();
    private final LinksRegistry links = new LinksRegistryImpl();

    ManagerModule() {
    }

    public Features features() {
        return this.features;
    }

    public ServicesRegistry services() {
        return this.services;
    }

    public LinksRegistry links() {
        return this.links;
    }

    public <S extends Service> S getFast(Class<S> service, Scope ... scopes) {
        try {
            return this.get(service, scopes);
        }
        catch (ManagerException e) {
            Object[] scopesArray = ScopeUtil.scopesToArray(true, scopes);
            throw new ManagerRuntimeException("getFast(" + service + ", " + ToStringUtils.toString((Object[])scopesArray) + ") failed to obtain service instance", e);
        }
    }

    public <S extends Service> S get(Class<S> service, Scope ... scopes) throws ManagerException {
        Validations.checkArgument((service != null ? 1 : 0) != 0, (Object)"service argument is null");
        Scope[] scopesArray = ScopeUtil.scopesToArray(true, scopes);
        ServiceConfiguration<S> conf = this.resolveConfigurationWithFeatures(service, scopesArray);
        if (conf == null) {
            throw new ConfigurationNotFoundException();
        }
        return this.getInstance(conf, true);
    }

    public <S extends Service> boolean isRegistered(Class<S> service, Scope ... scopes) {
        Scope[] scopesArray = ScopeUtil.scopesToArray(true, scopes);
        return this.resolveConfigurationWithFeatures(service, scopesArray) != null;
    }

    private <S extends Service> ServiceConfiguration<S> resolveConfigurationWithFeatures(Class<S> service, Scope ... scopes) {
        ServiceConfiguration<S> conf = this.resolveConfiguration(service, scopes);
        if (conf == null && this.features().isEnabled(Manager.Feature.AUTO_IMPL_DISCOVERY)) {
            this.featureAutoImplDiscovery(service, scopes);
            conf = this.resolveConfiguration(service, scopes);
        }
        return conf;
    }

    private <S extends Service> ServiceConfiguration<S> resolveConfiguration(Class<S> service, Scope ... scopes) {
        String key = ManagerUtils.resolveKey(service, scopes);
        ServiceConfiguration conf = this.services().get(key);
        if (conf != null) {
            return conf;
        }
        Scope[] scope = this.links().get(key);
        if (scope != null) {
            return this.resolveConfiguration(service, scope);
        }
        return null;
    }

    private <S extends Service> S getInstance(ServiceConfiguration<S> conf, boolean postConstruct) throws ManagerException {
        if (conf.getInstance() != null) {
            return conf.getInstance();
        }
        Object object = this.lock;
        synchronized (object) {
            if (conf.getInstance() != null) {
                return conf.getInstance();
            }
            ServiceFactory<S> factory = conf.getFactory();
            try {
                S instance = factory.create(conf.getFactoryConf());
                conf.setInstance(instance);
                if (postConstruct) {
                    ClassUtils.executePostConstruct(instance, (boolean)true);
                }
                return instance;
            }
            catch (RuntimeException e) {
                throw new ManagerException("Can't instantiate service", e);
            }
        }
    }

    private <S extends Service> void featureAutoImplDiscovery(Class<S> service, Scope ... scopes) {
        if (scopes.length != 1 && scopes[0] != Manager.DEFAULT_SCOPE) {
            return;
        }
        String serviceClassName = service.getName();
        String implClassName = serviceClassName + "Impl";
        try {
            Class implClass = (Class)CastUtils.cast(Class.forName(implClassName));
            this.services().register(service, new DynamicServiceFactory(implClass), Configuration.EMPTY, scopes);
            return;
        }
        catch (ClassNotFoundException e) {
            LoggingUtils.debug((Logger)LOGGER, (String)("Step[1]: service[" + serviceClassName + "] implementation[" + implClassName + "] class is not found"));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warmUp() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList instances = new ArrayList();
            for (ServiceConfiguration<?> conf : this.services().getAll()) {
                if (conf.getInstance() != null) continue;
                try {
                    instances.add(this.getInstance(conf, false));
                }
                catch (ManagerException e) {
                    throw new ManagerRuntimeException("Can't warm up", e);
                }
            }
            for (ServiceConfiguration<Object> instance : instances) {
                try {
                    ClassUtils.executePostConstruct(instance, (boolean)true);
                }
                catch (RuntimeException e) {
                    throw new ManagerRuntimeException("Can't warm up", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S extends Service> void warmUp(Class<S> service) {
        Object object = this.lock;
        synchronized (object) {
            ArrayList instances = new ArrayList();
            for (ServiceConfiguration<?> conf : this.services().getAll()) {
                if (!conf.getService().equals(service) || conf.getInstance() != null) continue;
                try {
                    instances.add(this.getInstance(conf, false));
                }
                catch (ManagerException e) {
                    throw new ManagerRuntimeException("Can't warm up", e);
                }
            }
            for (ServiceConfiguration<Object> instance : instances) {
                try {
                    ClassUtils.executePostConstruct(instance, (boolean)true);
                }
                catch (RuntimeException e) {
                    throw new ManagerRuntimeException("Can't warm up", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList values = new ArrayList(this.services().getAll());
            this.services().clear();
            this.links().clear();
            this.features().clear();
            for (ServiceConfiguration serviceConfiguration : values) {
                if (serviceConfiguration.getInstance() == null) continue;
                ClassUtils.executePreDestroy(serviceConfiguration.getInstance(), (boolean)true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S extends Service> void tearDown(Class<S> service) {
        Object object = this.lock;
        synchronized (object) {
            ArrayList instances = new ArrayList();
            for (ServiceConfiguration<?> serviceConfiguration : this.services().getAll()) {
                if (!serviceConfiguration.getService().equals(service)) continue;
                instances.add(serviceConfiguration);
            }
            for (ServiceConfiguration<Object> serviceConfiguration : instances) {
                this.services().clear(serviceConfiguration.toKey());
                if (serviceConfiguration.getInstance() == null) continue;
                ClassUtils.executePreDestroy((Object)serviceConfiguration.getInstance(), (boolean)true);
            }
            this.links().clear(service);
        }
    }
}

