/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.ioc.features;

import java.util.EnumMap;
import java.util.Map;
import net.bolbat.kit.ioc.Manager;
import net.bolbat.kit.ioc.features.Features;

public class FeaturesImpl
implements Features {
    private final Object lock = new Object();
    private transient Map<Manager.Feature, Boolean> features = new EnumMap<Manager.Feature, Boolean>(Manager.Feature.class);

    public FeaturesImpl() {
        this.configureToDefaults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enable(Manager.Feature ... toEnable) {
        if (toEnable == null || toEnable.length == 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            EnumMap<Manager.Feature, Boolean> newConfiguration = new EnumMap<Manager.Feature, Boolean>(this.features);
            for (Manager.Feature feature : toEnable) {
                if (feature == null) continue;
                newConfiguration.put(feature, Boolean.TRUE);
            }
            this.features = newConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disable(Manager.Feature ... toDisable) {
        if (toDisable == null || toDisable.length == 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            EnumMap<Manager.Feature, Boolean> newConfiguration = new EnumMap<Manager.Feature, Boolean>(this.features);
            for (Manager.Feature feature : toDisable) {
                if (feature == null) continue;
                newConfiguration.put(feature, Boolean.FALSE);
            }
            this.features = newConfiguration;
        }
    }

    @Override
    public boolean isEnabled(Manager.Feature feature) {
        return Boolean.TRUE.equals(this.features.get((Object)feature));
    }

    @Override
    public void clear() {
        this.features = new EnumMap<Manager.Feature, Boolean>(Manager.Feature.class);
        this.configureToDefaults();
    }

    private void configureToDefaults() {
        for (Manager.Feature feature : Manager.Feature.values()) {
            if (feature.isEnabledByDefault()) {
                this.enable(feature);
                continue;
            }
            this.disable(feature);
        }
    }
}

