/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.ioc.links;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.bolbat.kit.ioc.Manager;
import net.bolbat.kit.ioc.ManagerUtils;
import net.bolbat.kit.ioc.links.LinksRegistry;
import net.bolbat.kit.ioc.scope.CompositeScope;
import net.bolbat.kit.ioc.scope.Scope;
import net.bolbat.kit.service.Service;
import net.bolbat.utils.lang.Validations;

public class LinksRegistryImpl
implements LinksRegistry {
    private final ConcurrentMap<String, Scope[]> storage = new ConcurrentHashMap<String, Scope[]>();

    @Override
    public Scope[] get(String key) {
        return (Scope[])this.storage.get(key);
    }

    @Override
    public <S extends Service> void link(Class<S> service, Scope target) {
        this.link(service, Manager.DEFAULT_SCOPE, target);
    }

    @Override
    public <S extends Service> void link(Class<S> service, Scope source, Scope target) {
        Scope[] scopeArray;
        Validations.checkArgument((service != null ? 1 : 0) != 0, (Object)"service argument is null");
        Validations.checkArgument((source != null ? 1 : 0) != 0, (Object)"source argument is null");
        Validations.checkArgument((target != null ? 1 : 0) != 0, (Object)"target argument is null");
        Validations.checkArgument((!source.getId().equalsIgnoreCase(target.getId()) ? 1 : 0) != 0, (Object)("source[" + source + "] and target[" + target + "] scopes is equal."));
        String sourceKey = ManagerUtils.resolveKey(service, source);
        if (target instanceof CompositeScope) {
            scopeArray = ((CompositeScope)CompositeScope.class.cast(target)).getScopes();
        } else {
            Scope[] scopeArray2 = new Scope[1];
            scopeArray = scopeArray2;
            scopeArray2[0] = target;
        }
        Scope[] targetScopes = scopeArray;
        this.storage.put(sourceKey, targetScopes);
    }

    @Override
    public <S extends Service> void clear(Class<S> service) {
        String serviceLinkPrefix = service.getName() + "_";
        for (Map.Entry linkEntry : this.storage.entrySet()) {
            if (!((String)linkEntry.getKey()).startsWith(serviceLinkPrefix)) continue;
            this.storage.remove(linkEntry.getKey());
        }
    }

    @Override
    public void clear() {
        this.storage.clear();
    }
}

