/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.ioc.scope;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import net.bolbat.kit.ioc.Manager;
import net.bolbat.kit.ioc.scope.CompositeScope;
import net.bolbat.kit.ioc.scope.Scope;
import net.bolbat.utils.lang.StringUtils;

public final class ScopeUtil {
    private ScopeUtil() {
        throw new IllegalAccessError("Can't instantiate.");
    }

    public static String scopesToString(Scope ... scopes) {
        if (scopes == null || scopes.length == 0) {
            return "";
        }
        ArrayList<String> scopesIds = new ArrayList<String>();
        for (Scope scope : ScopeUtil.scopesToArray(false, scopes)) {
            if (scope == null || !StringUtils.isNotEmpty((String)scope.getId())) continue;
            scopesIds.add(scope.getId());
        }
        if (scopesIds.isEmpty()) {
            return "";
        }
        Collections.sort(scopesIds);
        StringBuilder sb = new StringBuilder("[");
        for (String scopeId : scopesIds) {
            if (sb.length() > 1) {
                sb.append(",");
            }
            sb.append(scopeId);
        }
        sb.append("]");
        return sb.toString();
    }

    public static Scope[] scopesToArray(boolean addDefault, Scope ... scopes) {
        ArrayList<Scope> aScopesList = new ArrayList<Scope>();
        HashSet<String> added = new HashSet<String>();
        if (scopes != null && scopes.length > 0) {
            for (Scope scope : scopes) {
                if (scope == null) continue;
                if (!(scope instanceof CompositeScope)) {
                    if (added.contains(scope.getId())) continue;
                    aScopesList.add(scope);
                    added.add(scope.getId());
                    continue;
                }
                CompositeScope composite = (CompositeScope)CompositeScope.class.cast(scope);
                for (Scope cScope : composite.getScopes()) {
                    if (cScope == null || added.contains(cScope.getId())) continue;
                    aScopesList.add(cScope);
                    added.add(cScope.getId());
                }
            }
        }
        if (aScopesList.isEmpty() && addDefault) {
            aScopesList.add(Manager.DEFAULT_SCOPE);
        }
        return aScopesList.toArray(new Scope[aScopesList.size()]);
    }
}

