/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.ioc.services;

import net.bolbat.kit.ioc.ManagerUtils;
import net.bolbat.kit.ioc.scope.Scope;
import net.bolbat.kit.service.Configuration;
import net.bolbat.kit.service.Service;
import net.bolbat.kit.service.ServiceFactory;
import net.bolbat.utils.lang.ToStringUtils;

public class ServiceConfiguration<S extends Service> {
    private final Class<S> service;
    private final ServiceFactory<S> factory;
    private final Configuration factoryConf;
    private final Scope[] scopes;
    private S instance;

    ServiceConfiguration(Class<S> aService, ServiceFactory<S> aFactory, Configuration aFactoryConf, Scope[] aScopes) {
        this.service = aService;
        this.factory = aFactory;
        this.factoryConf = aFactoryConf != null ? aFactoryConf : Configuration.EMPTY;
        this.scopes = aScopes;
    }

    ServiceConfiguration(Class<S> aService, S aInstance, Scope[] aScopes) {
        this.service = aService;
        this.factory = null;
        this.factoryConf = Configuration.EMPTY;
        this.scopes = aScopes;
        this.instance = aInstance;
    }

    public Class<S> getService() {
        return this.service;
    }

    public ServiceFactory<S> getFactory() {
        return this.factory;
    }

    public Configuration getFactoryConf() {
        return this.factoryConf;
    }

    public S getInstance() {
        return this.instance;
    }

    public void setInstance(S aInstance) {
        this.instance = aInstance;
    }

    public String toKey() {
        return ManagerUtils.resolveKey(this.service, this.scopes);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append(" [service=").append(this.service);
        builder.append(", factory=").append(this.factory);
        builder.append(", factoryConf=").append(this.factoryConf);
        builder.append(", scopes=").append(ToStringUtils.toString((Object[])this.scopes));
        builder.append(", instance=").append(this.instance != null ? this.instance.getClass().getName() : null);
        builder.append("]");
        return builder.toString();
    }
}

