/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.ioc.services;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.bolbat.kit.ioc.Manager;
import net.bolbat.kit.ioc.scope.Scope;
import net.bolbat.kit.ioc.scope.ScopeUtil;
import net.bolbat.kit.ioc.services.ServiceConfiguration;
import net.bolbat.kit.ioc.services.ServicesRegistry;
import net.bolbat.kit.service.Configuration;
import net.bolbat.kit.service.Service;
import net.bolbat.kit.service.ServiceFactory;
import net.bolbat.utils.lang.CastUtils;
import net.bolbat.utils.lang.Validations;
import net.bolbat.utils.reflect.Instantiator;

public class ServicesRegistryImpl
implements ServicesRegistry {
    private final ConcurrentMap<String, ServiceConfiguration<?>> storage = new ConcurrentHashMap();

    @Override
    public Collection<ServiceConfiguration<?>> getAll() {
        return Collections.unmodifiableCollection(this.storage.values());
    }

    @Override
    public <S extends Service> ServiceConfiguration<S> get(String key) {
        return (ServiceConfiguration)CastUtils.cast(this.storage.get(key));
    }

    @Override
    public <S extends Service, SF extends ServiceFactory<S>> void register(Class<S> service, Class<SF> factory) {
        this.register(service, (S)((Object)factory), Manager.DEFAULT_SCOPE);
    }

    @Override
    public <S extends Service, SF extends ServiceFactory<S>> void register(Class<S> service, Class<SF> factory, Scope ... scopes) {
        this.register(service, (SF)((Object)factory), Configuration.EMPTY, scopes);
    }

    @Override
    public <S extends Service, SF extends ServiceFactory<S>> void register(Class<S> service, Class<SF> factory, Configuration conf) {
        this.register(service, (SF)((Object)factory), conf, Manager.DEFAULT_SCOPE);
    }

    @Override
    public <S extends Service, SF extends ServiceFactory<S>> void register(Class<S> service, Class<SF> factory, Configuration conf, Scope ... scopes) {
        ServiceFactory instance = (ServiceFactory)Instantiator.instantiate(factory);
        this.register(service, instance, conf, scopes);
    }

    @Override
    public <S extends Service, SF extends ServiceFactory<S>> void register(Class<S> service, SF factory) {
        this.register(service, factory, Configuration.EMPTY, Manager.DEFAULT_SCOPE);
    }

    @Override
    public <S extends Service, SF extends ServiceFactory<S>> void register(Class<S> service, SF factory, Scope ... scopes) {
        this.register(service, factory, Configuration.EMPTY, scopes);
    }

    @Override
    public <S extends Service, SF extends ServiceFactory<S>> void register(Class<S> service, SF factory, Configuration conf) {
        this.register(service, factory, conf, Manager.DEFAULT_SCOPE);
    }

    @Override
    public <S extends Service, SF extends ServiceFactory<S>> void register(Class<S> service, SF factory, Configuration conf, Scope ... scopes) {
        Validations.checkArgument((service != null ? 1 : 0) != 0, (Object)"service argument is null");
        Validations.checkArgument((factory != null ? 1 : 0) != 0, (Object)"serviceFactory argument is null");
        ServiceConfiguration<S> sConfig = new ServiceConfiguration<S>(service, factory, conf, ScopeUtil.scopesToArray(true, scopes));
        this.storage.put(sConfig.toKey(), sConfig);
    }

    @Override
    public <S extends Service> void register(Class<S> service, S instance) {
        this.register(service, instance, Manager.DEFAULT_SCOPE);
    }

    @Override
    public <S extends Service> void register(Class<S> service, S instance, Scope ... scopes) {
        Validations.checkArgument((service != null ? 1 : 0) != 0, (Object)"service argument is null");
        Validations.checkArgument((instance != null ? 1 : 0) != 0, (Object)"instance argument is null");
        ServiceConfiguration<S> sConfig = new ServiceConfiguration<S>(service, instance, ScopeUtil.scopesToArray(true, scopes));
        this.storage.put(sConfig.toKey(), sConfig);
    }

    @Override
    public void clear(String key) {
        this.storage.remove(key);
    }

    @Override
    public void clear() {
        this.storage.clear();
    }
}

