/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.lucene;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.bolbat.kit.config.ConfigurationManager;
import net.bolbat.kit.lucene.LuceneStore;
import net.bolbat.kit.lucene.LuceneStoreConfig;
import net.bolbat.kit.lucene.LuceneStoreRuntimeException;
import net.bolbat.kit.lucene.LuceneUtils;
import net.bolbat.kit.lucene.Storable;
import net.bolbat.utils.lang.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Bits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneStoreImpl<S extends Storable>
implements LuceneStore<S> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LuceneStoreImpl.class);
    private static final String DOCUMENT_DATA_FIELD_NAME = "BEAN_DATA";
    private final LuceneStoreConfig config;
    private final Directory directory;
    private final Analyzer analyzer;
    private final IndexWriterConfig writerConfig;
    private final IndexWriter writer;
    private volatile IndexReader reader;
    private volatile IndexSearcher searcher;
    private final Class<S> beanType;
    private final ObjectMapper mapper;
    private final Object lock = new Object();

    protected LuceneStoreImpl(Class<S> aBeanType, String configuration) {
        this(aBeanType, ConfigurationManager.getInstanceForConf(LuceneStoreConfig.class, configuration));
    }

    protected LuceneStoreImpl(Class<S> aBeanType, LuceneStoreConfig configuration) {
        if (aBeanType == null) {
            throw new IllegalArgumentException("aBeanType argument is null");
        }
        this.config = configuration;
        LOGGER.info("Type[" + aBeanType + "], " + configuration.toString());
        try {
            Path path = Paths.get(this.config.getDirectoryPath(), new String[0]);
            this.directory = FSDirectory.open((Path)path);
            this.analyzer = new StandardAnalyzer();
            this.writerConfig = new IndexWriterConfig(this.analyzer);
            this.writer = new IndexWriter(this.directory, this.writerConfig);
            this.writer.commit();
            this.beanType = aBeanType;
            this.mapper = new ObjectMapper();
            this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.mapper.configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, false);
            this.mapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        }
        catch (IOException e) {
            throw new LuceneStoreRuntimeException(e);
        }
    }

    @Override
    public Collection<S> getAll() {
        try {
            ArrayList<Object> result = new ArrayList<Object>();
            Collection<Document> documents = this.getAllDocuments();
            for (Document doc : documents) {
                result.add(this.mapper.readValue(doc.get(DOCUMENT_DATA_FIELD_NAME), this.beanType));
            }
            return result;
        }
        catch (IOException e) {
            throw new LuceneStoreRuntimeException(e);
        }
    }

    @Override
    public Collection<Document> getAllDocuments() {
        try {
            IndexReader localReader = this.getReader();
            Bits liveDocs = MultiFields.getLiveDocs((IndexReader)localReader);
            ArrayList<Document> result = new ArrayList<Document>();
            for (int i = 0; i < localReader.maxDoc(); ++i) {
                if (liveDocs != null && !liveDocs.get(i)) continue;
                result.add(localReader.document(i));
            }
            return result;
        }
        catch (IOException e) {
            throw new LuceneStoreRuntimeException(e);
        }
    }

    @Override
    public S get(String fieldName, String fieldValue) {
        if (StringUtils.isEmpty((String)fieldName)) {
            throw new IllegalArgumentException("fieldName argument is empty");
        }
        if (StringUtils.isEmpty((String)fieldValue)) {
            throw new IllegalArgumentException("fieldValue argument is empty");
        }
        try {
            Document doc = this.getDocument(fieldName, fieldValue);
            return (S)(doc != null ? (Storable)this.mapper.readValue(doc.get(DOCUMENT_DATA_FIELD_NAME), this.beanType) : null);
        }
        catch (IOException e) {
            throw new LuceneStoreRuntimeException(e);
        }
    }

    @Override
    public Document getDocument(String fieldName, String fieldValue) {
        if (StringUtils.isEmpty((String)fieldName)) {
            throw new IllegalArgumentException("fieldName argument is empty");
        }
        if (StringUtils.isEmpty((String)fieldValue)) {
            throw new IllegalArgumentException("fieldValue argument is empty");
        }
        try {
            IndexSearcher localSearcher = this.getSearcher();
            BooleanQuery query = new BooleanQuery.Builder().add((Query)new TermQuery(new Term(fieldName, fieldValue)), BooleanClause.Occur.MUST).build();
            TopDocs topDocs = localSearcher.search((Query)query, 1);
            if (topDocs.scoreDocs.length == 0) {
                return null;
            }
            return localSearcher.doc(topDocs.scoreDocs[0].doc);
        }
        catch (IOException e) {
            throw new LuceneStoreRuntimeException(e);
        }
    }

    @Override
    public void add(S toAdd) {
        if (toAdd == null) {
            throw new IllegalArgumentException("toAdd argument is null");
        }
        if (StringUtils.isEmpty((String)toAdd.idFieldName())) {
            throw new IllegalArgumentException("toAdd.idFieldName argument is empty");
        }
        if (StringUtils.isEmpty((String)toAdd.idFieldValue())) {
            throw new IllegalArgumentException("toAdd.idFieldValue argument is empty");
        }
        try {
            Document doc = toAdd.toDocument();
            doc.add((IndexableField)new TextField(DOCUMENT_DATA_FIELD_NAME, this.mapper.writeValueAsString(toAdd), Field.Store.YES));
            this.writer.addDocument((Iterable)doc);
            this.writer.commit();
        }
        catch (IOException e) {
            throw new LuceneStoreRuntimeException(e);
        }
        finally {
            this.cleanAfterCommit();
        }
    }

    @Override
    public void update(S toUpdate) {
        if (toUpdate == null) {
            throw new IllegalArgumentException("toUpdate argument is null");
        }
        if (StringUtils.isEmpty((String)toUpdate.idFieldName())) {
            throw new IllegalArgumentException("toRemove.idFieldName argument is empty");
        }
        if (StringUtils.isEmpty((String)toUpdate.idFieldValue())) {
            throw new IllegalArgumentException("toUpdate.idFieldValue argument is empty");
        }
        try {
            Document doc = toUpdate.toDocument();
            doc.add((IndexableField)new TextField(DOCUMENT_DATA_FIELD_NAME, this.mapper.writeValueAsString(toUpdate), Field.Store.YES));
            this.writer.updateDocument(new Term(toUpdate.idFieldName(), toUpdate.idFieldValue()), (Iterable)doc);
            this.writer.commit();
        }
        catch (IOException e) {
            throw new LuceneStoreRuntimeException(e);
        }
        finally {
            this.cleanAfterCommit();
        }
    }

    @Override
    public void remove(S toRemove) {
        if (toRemove == null) {
            throw new IllegalArgumentException("toRemove argument is null");
        }
        if (StringUtils.isEmpty((String)toRemove.idFieldName())) {
            throw new IllegalArgumentException("toRemove.idFieldName argument is empty");
        }
        if (StringUtils.isEmpty((String)toRemove.idFieldValue())) {
            throw new IllegalArgumentException("toRemove.idFieldValue argument is empty");
        }
        try {
            this.writer.deleteDocuments(new Term[]{new Term(toRemove.idFieldName(), toRemove.idFieldValue())});
            this.writer.commit();
        }
        catch (IOException e) {
            throw new LuceneStoreRuntimeException(e);
        }
        finally {
            this.cleanAfterCommit();
        }
    }

    @Override
    public void add(Collection<S> toAdd) {
        if (toAdd == null) {
            throw new IllegalArgumentException("toAdd argument is null");
        }
        if (toAdd.isEmpty()) {
            return;
        }
        try {
            ArrayList<Document> docs = new ArrayList<Document>();
            for (Storable bean : toAdd) {
                if (bean == null || StringUtils.isEmpty((String)bean.idFieldName()) || StringUtils.isEmpty((String)bean.idFieldValue())) continue;
                Document doc = bean.toDocument();
                doc.add((IndexableField)new TextField(DOCUMENT_DATA_FIELD_NAME, this.mapper.writeValueAsString((Object)bean), Field.Store.YES));
                docs.add(doc);
            }
            this.writer.addDocuments(docs);
            this.writer.commit();
        }
        catch (IOException e) {
            throw new LuceneStoreRuntimeException(e);
        }
        finally {
            this.cleanAfterCommit();
        }
    }

    @Override
    public void update(Collection<S> toUpdate) {
        if (toUpdate == null) {
            throw new IllegalArgumentException("toUpdate argument is null");
        }
        if (toUpdate.isEmpty()) {
            return;
        }
        try {
            for (Storable bean : toUpdate) {
                if (bean == null || StringUtils.isEmpty((String)bean.idFieldName()) || StringUtils.isEmpty((String)bean.idFieldValue())) continue;
                Document doc = bean.toDocument();
                doc.add((IndexableField)new TextField(DOCUMENT_DATA_FIELD_NAME, this.mapper.writeValueAsString((Object)bean), Field.Store.YES));
                this.writer.updateDocument(new Term(bean.idFieldName(), bean.idFieldValue()), (Iterable)doc);
            }
            this.writer.commit();
        }
        catch (IOException e) {
            throw new LuceneStoreRuntimeException(e);
        }
        finally {
            this.cleanAfterCommit();
        }
    }

    @Override
    public void remove(Collection<S> toRemove) {
        if (toRemove == null) {
            throw new IllegalArgumentException("toRemove argument is null");
        }
        if (toRemove.isEmpty()) {
            return;
        }
        try {
            for (Storable bean : toRemove) {
                if (bean == null || StringUtils.isEmpty((String)bean.idFieldName()) || StringUtils.isEmpty((String)bean.idFieldValue())) continue;
                this.writer.deleteDocuments(new Term[]{new Term(bean.idFieldName(), bean.idFieldValue())});
            }
            this.writer.commit();
        }
        catch (IOException e) {
            throw new LuceneStoreRuntimeException(e);
        }
        finally {
            this.cleanAfterCommit();
        }
    }

    @Override
    public void removeAll() {
        try {
            this.writer.deleteAll();
            this.writer.commit();
        }
        catch (IOException e) {
            throw new LuceneStoreRuntimeException(e);
        }
        finally {
            this.cleanAfterCommit();
        }
    }

    @Override
    public int count() {
        return this.getReader().numDocs();
    }

    @Override
    public int count(Query query) {
        if (query == null) {
            throw new IllegalArgumentException("query argument is null");
        }
        try {
            return this.getSearcher().search((Query)query, (int)Integer.MAX_VALUE).scoreDocs.length;
        }
        catch (IOException e) {
            throw new LuceneStoreRuntimeException(e);
        }
    }

    @Override
    public Collection<S> get(Query query) {
        return this.get(query, 0, Integer.MAX_VALUE, null);
    }

    @Override
    public Collection<Document> getDocuments(Query query) {
        return this.getDocuments(query, 0, Integer.MAX_VALUE, null);
    }

    @Override
    public Collection<S> get(Query query, Sort sort) {
        return this.get(query, 0, Integer.MAX_VALUE, sort);
    }

    @Override
    public Collection<Document> getDocuments(Query query, Sort sort) {
        return this.getDocuments(query, 0, Integer.MAX_VALUE, sort);
    }

    @Override
    public Collection<S> get(Query query, int limit) {
        return this.get(query, 0, limit, null);
    }

    @Override
    public Collection<Document> getDocuments(Query query, int limit) {
        return this.getDocuments(query, 0, limit, null);
    }

    @Override
    public Collection<S> get(Query query, int offset, int limit) {
        return this.get(query, offset, limit, null);
    }

    @Override
    public Collection<Document> getDocuments(Query query, int offset, int limit) {
        return this.getDocuments(query, offset, limit, null);
    }

    @Override
    public Collection<S> get(Query query, int limit, Sort sort) {
        return this.get(query, 0, limit, sort);
    }

    @Override
    public Collection<Document> getDocuments(Query query, int limit, Sort sort) {
        return this.getDocuments(query, 0, limit, sort);
    }

    @Override
    public Collection<S> get(Query query, int offset, int limit, Sort sort) {
        if (query == null) {
            throw new IllegalArgumentException("query argument is null");
        }
        if (limit < 1) {
            return Collections.emptyList();
        }
        try {
            Collection<Document> docs = this.getDocuments(query, offset, limit, sort);
            ArrayList<Object> result = new ArrayList<Object>(docs.size());
            for (Document doc : docs) {
                if (doc == null) continue;
                result.add(this.mapper.readValue(doc.get(DOCUMENT_DATA_FIELD_NAME), this.beanType));
            }
            return result;
        }
        catch (IOException e) {
            throw new LuceneStoreRuntimeException(e);
        }
    }

    @Override
    public Collection<Document> getDocuments(Query query, int offset, int limit, Sort sort) {
        if (query == null) {
            throw new IllegalArgumentException("query argument is null");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset[" + offset + "] couldn't be less then 0");
        }
        if (limit < 1) {
            return Collections.emptyList();
        }
        try {
            IndexSearcher localSearcher = this.getSearcher();
            TopDocs topDocs = sort != null ? localSearcher.search(query, offset + limit, sort) : localSearcher.search(query, offset + limit);
            ArrayList<Document> result = new ArrayList<Document>();
            if (offset >= topDocs.scoreDocs.length) {
                return result;
            }
            for (int i = offset; i < topDocs.scoreDocs.length; ++i) {
                result.add(localSearcher.doc(topDocs.scoreDocs[i].doc));
            }
            return result;
        }
        catch (IOException e) {
            throw new LuceneStoreRuntimeException(e);
        }
    }

    @Override
    public synchronized void tearDown() {
        LuceneUtils.close(this.reader);
        LuceneUtils.close(this.analyzer);
        LuceneUtils.close(this.writer);
        LuceneUtils.close(this.directory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexReader getReader() {
        if (this.reader == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.reader == null) {
                    try {
                        this.reader = DirectoryReader.open((Directory)this.directory);
                    }
                    catch (IOException e) {
                        throw new LuceneStoreRuntimeException(e);
                    }
                }
            }
        }
        return this.reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexSearcher getSearcher() {
        if (this.searcher == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.searcher == null) {
                    this.searcher = new IndexSearcher(this.getReader());
                }
            }
        }
        return this.searcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanAfterCommit() {
        Object object = this.lock;
        synchronized (object) {
            LuceneUtils.close(this.reader);
            this.reader = null;
            this.searcher = null;
        }
    }
}

