/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.lucene;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.bolbat.kit.Module;
import net.bolbat.kit.config.ConfigurationManager;
import net.bolbat.kit.lucene.LuceneStore;
import net.bolbat.kit.lucene.LuceneStoreConfig;
import net.bolbat.kit.lucene.LuceneStoreImpl;
import net.bolbat.kit.lucene.Storable;
import net.bolbat.utils.lang.StringUtils;

public final class LuceneStoreManager
implements Module {
    private static final Map<String, LuceneStore<?>> STORAGE = new ConcurrentHashMap();
    private static final Object LOCK = new Object();

    private LuceneStoreManager() {
        throw new IllegalAccessError("Shouldn't be instantiated.");
    }

    public static <S extends Storable> LuceneStore<S> getStore(Class<S> type) {
        return LuceneStoreManager.getStore(type, "kit-lucene-store");
    }

    public static <S extends Storable> LuceneStore<S> getStore(Class<S> type, String configuration) {
        if (type == null) {
            throw new IllegalArgumentException("type argument is null");
        }
        String conf = StringUtils.isEmpty((String)configuration) ? "kit-lucene-store" : configuration;
        return LuceneStoreManager.getStore(type, ConfigurationManager.getInstanceForConf(LuceneStoreConfig.class, conf));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S extends Storable> LuceneStore<S> getStore(Class<S> type, LuceneStoreConfig configuration) {
        if (type == null) {
            throw new IllegalArgumentException("type argument is null");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("configuration argument is null");
        }
        String storeKey = type.getName() + "_" + configuration.hashCode();
        LuceneStore<?> result = STORAGE.get(storeKey);
        if (result == null) {
            Object object = LOCK;
            synchronized (object) {
                result = STORAGE.get(storeKey);
                if (result == null) {
                    result = new LuceneStoreImpl(type, configuration);
                    STORAGE.put(storeKey, result);
                }
            }
        }
        return result;
    }

    public static Set<String> getStoresIds() {
        return new HashSet<String>(STORAGE.keySet());
    }

    public static List<LuceneStore<?>> getStores() {
        return new ArrayList(STORAGE.values());
    }

    public static void tearDown() {
        STORAGE.clear();
    }

    public static <S extends Storable> void tearDown(Class<S> type) {
        LuceneStoreManager.tearDown(type, "kit-lucene-store");
    }

    public static <S extends Storable> void tearDown(Class<S> type, String configuration) {
        if (type == null) {
            return;
        }
        String conf = StringUtils.isEmpty((String)configuration) ? "kit-lucene-store" : configuration;
        LuceneStoreManager.tearDown(type, ConfigurationManager.getInstanceForConf(LuceneStoreConfig.class, conf));
    }

    public static <S extends Storable> void tearDown(Class<S> type, LuceneStoreConfig configuration) {
        if (type == null) {
            return;
        }
        if (configuration == null) {
            return;
        }
        String storeKey = type.getName() + "_" + configuration.hashCode();
        STORAGE.remove(storeKey);
    }
}

