/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.lucene;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LuceneUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(LuceneUtils.class);

    private LuceneUtils() {
        throw new IllegalAccessError("Shouldn't be instantiated.");
    }

    public static void close(IndexReader reader) {
        block3: {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                if (!LOGGER.isWarnEnabled()) break block3;
                LOGGER.warn("Unable to close IndexReader", (Throwable)e);
            }
        }
    }

    public static void close(Analyzer analyzer) {
        if (analyzer != null) {
            analyzer.close();
        }
    }

    public static void close(IndexWriter writer) {
        block3: {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                if (!LOGGER.isWarnEnabled()) break block3;
                LOGGER.warn("Unable to close IndexWriter", (Throwable)e);
            }
        }
    }

    public static void close(Directory directory) {
        block3: {
            try {
                if (directory != null) {
                    directory.close();
                }
            }
            catch (IOException e) {
                if (!LOGGER.isWarnEnabled()) break block3;
                LOGGER.warn("Unable to close Directory", (Throwable)e);
            }
        }
    }
}

