/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.orchestrator;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import net.bolbat.kit.config.AbstractConfiguration;
import net.bolbat.kit.config.ConfigurationManager;
import net.bolbat.kit.orchestrator.OrchestrationConstants;
import net.bolbat.kit.orchestrator.annotation.Orchestrate;
import net.bolbat.kit.orchestrator.annotation.OrchestrationExecutor;
import net.bolbat.kit.orchestrator.annotation.OrchestrationLimits;
import net.bolbat.kit.orchestrator.annotation.OrchestrationMode;
import net.bolbat.kit.orchestrator.impl.callable.CallableFactory;
import net.bolbat.kit.orchestrator.impl.callable.DefaultCallableFactory;
import net.bolbat.kit.orchestrator.impl.executor.DefaultExecutorServiceFactory;
import net.bolbat.kit.orchestrator.impl.executor.ExecutorServiceFactory;
import net.bolbat.utils.lang.StringUtils;
import org.configureme.annotations.AfterConfiguration;
import org.configureme.annotations.Configure;
import org.configureme.annotations.ConfigureMe;
import org.configureme.annotations.DontConfigure;

@ConfigureMe(allfields=false)
public class OrchestrationConfig
extends AbstractConfiguration {
    @DontConfigure
    private static final long serialVersionUID = -1895395871760275588L;
    @DontConfigure
    private Source source = Source.ANNOTATIONS;
    @Configure
    private ModeConfig modeConfig = new ModeConfig();
    @Configure
    private LimitsConfig limitsConfig = new LimitsConfig();
    @Configure
    private ExecutorConfig executorConfig = new ExecutorConfig();

    public Source getSource() {
        return this.source;
    }

    private void setSource(Source aSource) {
        this.source = aSource;
    }

    public ModeConfig getModeConfig() {
        return this.modeConfig;
    }

    public void setModeConfig(ModeConfig aModeConfig) {
        this.modeConfig = aModeConfig != null ? aModeConfig : new ModeConfig();
    }

    public LimitsConfig getLimitsConfig() {
        return this.limitsConfig;
    }

    public void setLimitsConfig(LimitsConfig aLimitsConfig) {
        this.limitsConfig = aLimitsConfig != null ? aLimitsConfig : new LimitsConfig();
    }

    public ExecutorConfig getExecutorConfig() {
        return this.executorConfig;
    }

    public void setExecutorConfig(ExecutorConfig aExecutorConfig) {
        this.executorConfig = aExecutorConfig != null ? aExecutorConfig : new ExecutorConfig();
    }

    public static OrchestrationConfig configure(Orchestrate orchestrate, OrchestrationLimits limits, OrchestrationExecutor executor) {
        return OrchestrationConfig.configure(orchestrate, null, limits, executor);
    }

    public static OrchestrationConfig configure(Orchestrate orchestrate, OrchestrationMode mode, OrchestrationLimits limits, OrchestrationExecutor executor) {
        OrchestrationConfig config = null;
        if (orchestrate != null && StringUtils.isNotEmpty((String)orchestrate.configName())) {
            config = ConfigurationManager.getInstanceForConf(OrchestrationConfig.class, orchestrate.configName());
        } else {
            config = new OrchestrationConfig();
            config.configure(mode, limits, executor);
        }
        return config;
    }

    public void configure(OrchestrationMode mode, OrchestrationLimits limits, OrchestrationExecutor executor) {
        this.setSource(Source.ANNOTATIONS);
        if (mode != null) {
            this.getModeConfig().setMode(mode.value());
        }
        if (limits != null) {
            this.getLimitsConfig().setTime(limits.time());
            this.getLimitsConfig().setTimeUnit(limits.timeUnit());
            this.getLimitsConfig().setConcurrent(limits.concurrent());
        }
        if (executor != null) {
            this.getExecutorConfig().setFactory(executor.factory());
            this.getExecutorConfig().setCallableFactory(executor.callableFactory());
            this.getExecutorConfig().setCoreSize(executor.coreSize());
            this.getExecutorConfig().setMaxSize(executor.maxSize());
            this.getExecutorConfig().setQueueSize(executor.queueSize());
            this.getExecutorConfig().setKeepAlive(executor.keepAlive());
            this.getExecutorConfig().setKeepAliveUnit(executor.keepAliveUnit());
            this.getExecutorConfig().setNameFormat(executor.nameFormat());
        }
    }

    @AfterConfiguration
    public void afterConfiguration() {
        this.setSource(Source.CONFIGURE_ME);
        this.fireConfigurationChanged();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append(" [source=").append((Object)this.source);
        builder.append(", modeConfig=[").append(this.getModeConfig()).append("]");
        builder.append(", limitsConfig=[").append(this.limitsConfig).append("]");
        builder.append(", executorConfig=[").append(this.executorConfig).append("]");
        builder.append("]");
        return builder.toString();
    }

    public static enum Source {
        ANNOTATIONS,
        CONFIGURE_ME;

    }

    @ConfigureMe(allfields=false)
    public static class ExecutorConfig
    implements Serializable {
        @DontConfigure
        private static final long serialVersionUID = 9058169478068158733L;
        @DontConfigure
        private Class<? extends ExecutorServiceFactory> factory = DefaultExecutorServiceFactory.class;
        @DontConfigure
        private Class<? extends CallableFactory> callableFactory = DefaultCallableFactory.class;
        @Configure
        private int coreSize = 0;
        @Configure
        private int maxSize = 0;
        @Configure
        private int queueSize = 0;
        @Configure
        private long keepAlive = 60L;
        @Configure
        private TimeUnit keepAliveUnit = OrchestrationConstants.POOL_KEEP_ALIVE_UNIT;
        @Configure
        private String nameFormat = "Orchestrator[%1$s]-n[%2$s]-thread[%3$d]";

        public Class<? extends ExecutorServiceFactory> getFactory() {
            return this.factory;
        }

        public void setFactory(Class<? extends ExecutorServiceFactory> aFactory) {
            this.factory = aFactory;
        }

        public Class<? extends CallableFactory> getCallableFactory() {
            return this.callableFactory;
        }

        public void setCallableFactory(Class<? extends CallableFactory> aCallableFactory) {
            this.callableFactory = aCallableFactory;
        }

        public int getCoreSize() {
            return this.coreSize;
        }

        public void setCoreSize(int coreSize) {
            this.coreSize = coreSize;
        }

        public int getMaxSize() {
            return this.maxSize;
        }

        public void setMaxSize(int maxSize) {
            this.maxSize = maxSize;
        }

        public int getQueueSize() {
            return this.queueSize;
        }

        public void setQueueSize(int queueSize) {
            this.queueSize = queueSize;
        }

        public long getKeepAlive() {
            return this.keepAlive;
        }

        public void setKeepAlive(long keepAlive) {
            this.keepAlive = keepAlive;
        }

        public TimeUnit getKeepAliveUnit() {
            return this.keepAliveUnit;
        }

        public void setKeepAliveUnit(TimeUnit keepAliveUnit) {
            this.keepAliveUnit = keepAliveUnit;
        }

        public String getNameFormat() {
            return this.nameFormat;
        }

        public void setNameFormat(String nameFormat) {
            this.nameFormat = nameFormat;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("factory=").append(this.factory);
            builder.append(", callableFactory=").append(this.callableFactory);
            builder.append(", coreSize=").append(this.coreSize);
            builder.append(", maxSize=").append(this.maxSize == 0 ? "unlimited" : Integer.valueOf(this.maxSize));
            builder.append(", queueSize=").append(this.queueSize == 0 ? "unlimited" : Integer.valueOf(this.queueSize));
            builder.append(", keepAlive=").append(this.keepAlive);
            builder.append(", keepAliveUnit=").append((Object)this.keepAliveUnit);
            builder.append(", nameFormat=").append(this.nameFormat);
            return builder.toString();
        }
    }

    @ConfigureMe(allfields=false)
    public static class LimitsConfig
    implements Serializable {
        @DontConfigure
        private static final long serialVersionUID = 1082218846823612100L;
        @Configure
        private int time = 0;
        @Configure
        private TimeUnit timeUnit = OrchestrationConstants.TIME_LIMIT_UNIT;
        @Configure
        private int concurrent = 0;

        public int getTime() {
            return this.time;
        }

        public void setTime(int time) {
            this.time = time;
        }

        public TimeUnit getTimeUnit() {
            return this.timeUnit;
        }

        public void setTimeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
        }

        public int getConcurrent() {
            return this.concurrent;
        }

        public void setConcurrent(int concurrent) {
            this.concurrent = concurrent;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("time=").append(this.time == 0 ? "unlimited" : Integer.valueOf(this.time));
            builder.append(", timeUnit=").append((Object)this.timeUnit);
            builder.append(", concurrent=").append(this.concurrent == 0 ? "unlimited" : Integer.valueOf(this.concurrent));
            return builder.toString();
        }
    }

    @ConfigureMe(allfields=false)
    public static class ModeConfig
    implements Serializable {
        private static final long serialVersionUID = -4263680889324891991L;
        @Configure
        private OrchestrationMode.Mode mode = OrchestrationMode.Mode.DEFAULT;

        public OrchestrationMode.Mode getMode() {
            return this.mode;
        }

        public void setMode(OrchestrationMode.Mode aMode) {
            this.mode = aMode;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("mode=").append((Object)this.mode);
            return builder.toString();
        }
    }
}

