/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.orchestrator.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.concurrent.TimeUnit;
import net.bolbat.kit.orchestrator.impl.callable.CallableFactory;
import net.bolbat.kit.orchestrator.impl.callable.DefaultCallableFactory;
import net.bolbat.kit.orchestrator.impl.executor.DefaultExecutorServiceFactory;
import net.bolbat.kit.orchestrator.impl.executor.ExecutorServiceFactory;
import net.bolbat.utils.annotation.Audience;
import net.bolbat.utils.annotation.Stability;

@Audience.Public
@Stability.Evolving
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.METHOD})
public @interface OrchestrationExecutor {
    public Class<? extends ExecutorServiceFactory> factory() default DefaultExecutorServiceFactory.class;

    public Class<? extends CallableFactory> callableFactory() default DefaultCallableFactory.class;

    public int coreSize() default 0;

    public int maxSize() default 0;

    public int queueSize() default 0;

    public long keepAlive() default 60L;

    public TimeUnit keepAliveUnit() default TimeUnit.SECONDS;

    public String nameFormat() default "Orchestrator[%1$s]-n[%2$s]-thread[%3$d]";
}

