/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.orchestrator.impl;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import net.bolbat.kit.orchestrator.impl.ExecutionInfo;
import net.bolbat.kit.orchestrator.impl.ExecutionUtils;
import net.bolbat.utils.lang.Validations;

public final class ExecutionCaches {
    private static final Map<String, ExecutionInfo> INFOS = new ConcurrentHashMap<String, ExecutionInfo>();
    private static final Map<String, ExecutorService> EXECUTORS = new ConcurrentHashMap<String, ExecutorService>();
    private static final Map<Method, Callable<Object>> CALLABLES = new ConcurrentHashMap<Method, Callable<Object>>();

    private ExecutionCaches() {
        throw new IllegalAccessError("Shouldn't be instantiated.");
    }

    public static ExecutionInfo getInfo(String id) {
        Validations.checkArgument((id != null ? 1 : 0) != 0, (Object)"id argument is null");
        return INFOS.get(id);
    }

    public static void cacheInfo(String id, ExecutionInfo info) {
        Validations.checkArgument((id != null ? 1 : 0) != 0, (Object)"id argument is null");
        Validations.checkArgument((info != null ? 1 : 0) != 0, (Object)"info argument is empty");
        INFOS.put(id, info);
    }

    public static ExecutorService getExecutor(String id) {
        Validations.checkArgument((id != null ? 1 : 0) != 0, (Object)"id argument is null");
        return EXECUTORS.get(id);
    }

    public static void cacheExecutor(String id, ExecutorService service) {
        Validations.checkArgument((id != null ? 1 : 0) != 0, (Object)"id argument is null");
        Validations.checkArgument((service != null ? 1 : 0) != 0, (Object)"service argument is empty");
        ExecutorService toShutdown = EXECUTORS.put(id, service);
        ExecutionCaches.shutdownExecutor(toShutdown);
    }

    public static void shutdownExecutor(String id) {
        ExecutorService toShutdown = EXECUTORS.remove(id);
        ExecutionCaches.shutdownExecutor(toShutdown);
    }

    public static void shutdownExecutor(ExecutorService toShutdown) {
        if (toShutdown != null) {
            ExecutionUtils.shutdown(toShutdown, false, 0L, TimeUnit.MILLISECONDS);
        }
    }

    public static Callable<Object> getCallable(Object impl, Method method, Object[] args) {
        Validations.checkArgument((impl != null ? 1 : 0) != 0, (Object)"impl argument is null");
        Validations.checkArgument((method != null ? 1 : 0) != 0, (Object)"method argument is null");
        if (method.getParameterTypes().length > 0) {
            return ExecutionUtils.createCallable(impl, method, args);
        }
        Callable<Object> result = CALLABLES.get(method);
        if (result == null) {
            result = ExecutionUtils.createCallable(impl, method, args);
            CALLABLES.put(method, result);
        }
        return result;
    }

    public static synchronized void tearDown() {
        Object removed;
        for (String id : INFOS.keySet()) {
            removed = INFOS.remove(id);
            ((ExecutionInfo)removed).unregisterFromConfigurationChanges();
        }
        for (String id : EXECUTORS.keySet()) {
            removed = EXECUTORS.remove(id);
            ExecutionUtils.terminate((ExecutorService)removed);
        }
        CALLABLES.clear();
    }
}

