/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.orchestrator.impl;

import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.bolbat.kit.orchestrator.OrchestrationConfig;
import net.bolbat.kit.orchestrator.annotation.Orchestrate;
import net.bolbat.kit.orchestrator.annotation.OrchestrationExecutor;
import net.bolbat.kit.orchestrator.annotation.OrchestrationLimits;
import net.bolbat.kit.orchestrator.annotation.OrchestrationMode;
import net.bolbat.kit.orchestrator.exception.OrchestrationException;
import net.bolbat.kit.orchestrator.impl.ExecutionCaches;
import net.bolbat.kit.orchestrator.impl.ExecutionInfo;
import net.bolbat.kit.orchestrator.impl.ExecutionUtils;
import net.bolbat.utils.concurrency.lock.IdBasedLock;
import net.bolbat.utils.concurrency.lock.IdBasedLockManager;
import net.bolbat.utils.concurrency.lock.SafeIdBasedLockManager;
import net.bolbat.utils.lang.ToStringUtils;
import net.bolbat.utils.reflect.proxy.AdvisedHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionHandler
extends AdvisedHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionHandler.class);
    private static final IdBasedLockManager<String> LOCK_MANAGER = new SafeIdBasedLockManager();
    private final ConcurrentMap<Method, String> methodIds = new ConcurrentHashMap<Method, String>();
    private final String instanceId = ExecutionUtils.objectId(this.getProxiedTarget());

    public ExecutionHandler(Object aTarget, Class<?>[] aInterfaces) {
        super(aTarget, (Class[])aInterfaces);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String executionId = this.resolveId(this.getProxiedTarget(), method);
        ExecutionInfo info = ExecutionHandler.resolveInstanceMethodInfo(this.instanceId, this.getProxiedTarget(), executionId, method);
        if (info.isOrchestrated()) {
            return ExecutionUtils.invoke(this.getProxiedTarget(), method, args, info);
        }
        return method.invoke(this.getProxiedTarget(), args);
    }

    public String resolveId(Object aInstance, Method aMethod) {
        String id = (String)this.methodIds.get(aMethod);
        if (id == null) {
            id = ExecutionUtils.methodId(aInstance, aMethod);
            this.methodIds.put(aMethod, id);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ExecutionInfo resolveInstanceInfo(String instanceId, Object instance) {
        ExecutionInfo info = ExecutionCaches.getInfo(instanceId);
        if (info != null) {
            return info;
        }
        IdBasedLock lock = LOCK_MANAGER.obtainLock((Object)instanceId);
        lock.lock();
        try {
            info = ExecutionCaches.getInfo(instanceId);
            if (info != null) {
                ExecutionInfo executionInfo = info;
                return executionInfo;
            }
            Class<?> implType = instance.getClass();
            info = new ExecutionInfo();
            info.setId(instanceId);
            info.setName(implType.getSimpleName());
            Orchestrate orchestrate = implType.getAnnotation(Orchestrate.class);
            OrchestrationLimits limits = implType.getAnnotation(OrchestrationLimits.class);
            OrchestrationExecutor executor = implType.getAnnotation(OrchestrationExecutor.class);
            info.setDisabled(orchestrate != null && !orchestrate.value());
            info.setOwnScope(orchestrate != null);
            info.setOwnLimits(limits != null);
            info.setOwnExecutor(executor != null);
            info.setConfig(OrchestrationConfig.configure(orchestrate, limits, executor));
            info.initActualConfiguration();
            ExecutionCaches.cacheInfo(instanceId, info);
            ExecutionInfo executionInfo = info;
            return executionInfo;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ExecutionInfo resolveInstanceMethodInfo(String instanceId, Object instance, String instanceMethodId, Method method) {
        ExecutionInfo info = ExecutionCaches.getInfo(instanceMethodId);
        if (info != null) {
            return info;
        }
        IdBasedLock lock = LOCK_MANAGER.obtainLock((Object)instanceMethodId);
        lock.lock();
        try {
            info = ExecutionCaches.getInfo(instanceMethodId);
            if (info != null) {
                ExecutionInfo executionInfo = info;
                return executionInfo;
            }
            ExecutionInfo classInfo = ExecutionHandler.resolveInstanceInfo(instanceId, instance);
            Class<?> implType = instance.getClass();
            Method implMethod = null;
            try {
                implMethod = implType.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException | SecurityException e) {
                String message = "Unable to get method[" + method + "] from impl type[" + implType + "]";
                LOGGER.warn(message, (Throwable)e);
                throw new OrchestrationException(message, e);
            }
            info = new ExecutionInfo();
            info.setId(instanceMethodId);
            info.setName(implType.getSimpleName() + "." + ToStringUtils.toMethodName((Method)implMethod));
            info.setClassInfo(classInfo);
            Orchestrate orchestrate = implMethod.getAnnotation(Orchestrate.class);
            OrchestrationLimits limits = implMethod.getAnnotation(OrchestrationLimits.class);
            OrchestrationExecutor executor = implMethod.getAnnotation(OrchestrationExecutor.class);
            OrchestrationMode mode = implMethod.getAnnotation(OrchestrationMode.class);
            info.setDisabled(orchestrate != null && !orchestrate.value());
            info.setOwnScope(orchestrate != null);
            info.setOwnLimits(limits != null);
            info.setOwnExecutor(executor != null);
            info.setConfig(OrchestrationConfig.configure(orchestrate, mode, limits, executor));
            info.initActualConfiguration();
            ExecutionCaches.cacheInfo(instanceMethodId, info);
            ExecutionInfo executionInfo = info;
            return executionInfo;
        }
        finally {
            lock.unlock();
        }
    }

    public synchronized void tearDown() {
        this.methodIds.clear();
    }
}

