/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.orchestrator.impl;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import net.bolbat.kit.config.ConfigurationListener;
import net.bolbat.kit.orchestrator.OrchestrationConfig;
import net.bolbat.kit.orchestrator.exception.OrchestrationException;
import net.bolbat.kit.orchestrator.impl.ExecutionCaches;
import net.bolbat.kit.orchestrator.impl.ExecutionUtils;
import net.bolbat.kit.orchestrator.impl.callable.CallableFactory;
import net.bolbat.kit.orchestrator.impl.callable.DefaultCallableFactory;
import net.bolbat.utils.concurrency.lock.IdBasedLock;
import net.bolbat.utils.concurrency.lock.IdBasedLockManager;
import net.bolbat.utils.concurrency.lock.SafeIdBasedLockManager;

public class ExecutionInfo
implements ConfigurationListener {
    private static final IdBasedLockManager<String> LOCK_MANAGER = new SafeIdBasedLockManager();
    private String id;
    private String name;
    private ExecutionInfo classInfo;
    private boolean disabled = true;
    private boolean ownScope = false;
    private boolean ownLimits = false;
    private boolean ownExecutor = false;
    private OrchestrationConfig config;
    private final AtomicInteger executions = new AtomicInteger(0);
    private transient boolean isOrchestrated;
    private transient OrchestrationConfig actualConfig;
    private transient OrchestrationConfig.LimitsConfig actualLimitsConfig;
    private transient OrchestrationConfig.ExecutorConfig actualExecutorConfig;
    private transient String actualExecutorId;
    private transient String actualExecutorName;
    private transient AtomicInteger actualExecutions;
    private transient CallableFactory actualCallableFactory;

    public String getId() {
        return this.id;
    }

    public void setId(String aId) {
        this.id = aId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public ExecutionInfo getClassInfo() {
        return this.classInfo;
    }

    public void setClassInfo(ExecutionInfo aClassInfo) {
        this.classInfo = aClassInfo;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean aDisabled) {
        this.disabled = aDisabled;
    }

    public boolean isOwnScope() {
        return this.ownScope;
    }

    public void setOwnScope(boolean aOwnScope) {
        this.ownScope = aOwnScope;
    }

    public boolean isOwnLimits() {
        return this.ownLimits;
    }

    public void setOwnLimits(boolean aOwnLimits) {
        this.ownLimits = aOwnLimits;
    }

    public boolean isOwnExecutor() {
        return this.ownExecutor;
    }

    public void setOwnExecutor(boolean aOwnExecutor) {
        this.ownExecutor = aOwnExecutor;
    }

    public OrchestrationConfig getConfig() {
        return this.config;
    }

    public void setConfig(OrchestrationConfig aConfig) {
        this.config = aConfig;
    }

    public AtomicInteger getExecutions() {
        return this.executions;
    }

    public boolean isOrchestrated() {
        return this.isOrchestrated;
    }

    public OrchestrationConfig getActualConfig() {
        return this.actualConfig;
    }

    public OrchestrationConfig.LimitsConfig getActualLimitsConfig() {
        return this.actualLimitsConfig;
    }

    public OrchestrationConfig.ExecutorConfig getActualExecutorConfig() {
        return this.actualExecutorConfig;
    }

    public String getActualExecutorId() {
        return this.actualExecutorId;
    }

    public String getActualExecutorName() {
        return this.actualExecutorName;
    }

    public AtomicInteger getActualExecutions() {
        return this.actualExecutions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService getActualExecutor() {
        ExecutorService service = ExecutionCaches.getExecutor(this.actualExecutorId);
        if (service != null) {
            return service;
        }
        IdBasedLock lock = LOCK_MANAGER.obtainLock((Object)this.actualExecutorId);
        lock.lock();
        try {
            service = ExecutionCaches.getExecutor(this.actualExecutorId);
            if (service != null) {
                ExecutorService executorService = service;
                return executorService;
            }
            service = ExecutionUtils.create(this.getActualExecutorConfig(), this.getActualExecutorId(), this.getActualExecutorName());
            ExecutionCaches.cacheExecutor(this.actualExecutorId, service);
            ExecutorService executorService = service;
            return executorService;
        }
        finally {
            lock.unlock();
        }
    }

    public CallableFactory getActualCallableFactory() {
        if (this.actualCallableFactory != null) {
            return this.actualCallableFactory;
        }
        Class<? extends CallableFactory> factory = this.getActualExecutorConfig().getCallableFactory();
        IdBasedLock lock = LOCK_MANAGER.obtainLock((Object)this.actualExecutorId);
        lock.lock();
        try {
            if (this.actualCallableFactory != null) {
                CallableFactory callableFactory = this.actualCallableFactory;
                return callableFactory;
            }
            if (DefaultCallableFactory.class == factory) {
                CallableFactory callableFactory = this.actualCallableFactory = DefaultCallableFactory.getInstance();
                return callableFactory;
            }
            CallableFactory callableFactory = this.actualCallableFactory = factory.newInstance();
            return callableFactory;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new OrchestrationException("Couldn't instantiate CallableFactory[" + factory + "]", e);
        }
        finally {
            lock.unlock();
        }
    }

    public void initActualConfiguration() {
        this.isOrchestrated = !this.disabled && (this.ownScope || this.classInfo != null && this.classInfo.isOrchestrated());
        this.actualConfig = this.ownScope ? this.config : this.classInfo.getConfig();
        this.actualLimitsConfig = this.ownScope || this.ownLimits ? this.config.getLimitsConfig() : this.classInfo.getConfig().getLimitsConfig();
        this.actualExecutorConfig = this.ownScope || this.ownExecutor ? this.config.getExecutorConfig() : this.classInfo.getConfig().getExecutorConfig();
        this.actualExecutorId = this.ownScope || this.ownExecutor ? this.id : this.classInfo.getId();
        this.actualExecutorName = this.ownScope || this.ownExecutor ? this.name : this.classInfo.getName();
        this.actualExecutions = this.ownScope || this.ownExecutor ? this.executions : this.classInfo.getExecutions();
        this.registerForConfigurationChanges();
    }

    public void registerForConfigurationChanges() {
        if (this.config != null && this.config.getSource() == OrchestrationConfig.Source.CONFIGURE_ME) {
            this.config.registerListener(this);
        }
    }

    public void unregisterFromConfigurationChanges() {
        if (this.config != null && this.config.getSource() == OrchestrationConfig.Source.CONFIGURE_ME) {
            this.config.unregisterListener(this);
        }
    }

    @Override
    public void configurationChanged() {
        ExecutionCaches.shutdownExecutor(this.getActualExecutorId());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionInfo)) {
            return false;
        }
        ExecutionInfo other = (ExecutionInfo)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

