/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.orchestrator.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.bolbat.kit.orchestrator.OrchestrationConfig;
import net.bolbat.kit.orchestrator.annotation.OrchestrationMode;
import net.bolbat.kit.orchestrator.exception.ConcurrentOverflowException;
import net.bolbat.kit.orchestrator.exception.ExecutionTimeoutException;
import net.bolbat.kit.orchestrator.exception.ExecutorOverflowException;
import net.bolbat.kit.orchestrator.exception.OrchestrationException;
import net.bolbat.kit.orchestrator.impl.ExecutionInfo;
import net.bolbat.kit.orchestrator.impl.executor.AsyncExecutorServiceFactory;
import net.bolbat.kit.orchestrator.impl.executor.DefaultExecutorServiceFactory;
import net.bolbat.kit.orchestrator.impl.executor.ExecutorServiceFactory;
import net.bolbat.kit.orchestrator.impl.executor.SystemExecutorServiceFactory;
import net.bolbat.utils.lang.Validations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionUtils.class);
    private static final ExecutorService ASYNC_EXECUTOR = AsyncExecutorServiceFactory.getInstance().create(null, new Object[0]);

    private ExecutionUtils() {
        throw new IllegalAccessError("Shouldn't be instantiated.");
    }

    public static String objectId(Object obj) {
        return Integer.toString(System.identityHashCode(obj));
    }

    public static String methodId(Object obj, Method method) {
        return ExecutionUtils.objectId(obj) + "-" + ExecutionUtils.objectId(method);
    }

    public static Callable<Object> createCallable(final Object impl, final Method method, final Object[] args) {
        Validations.checkArgument((impl != null ? 1 : 0) != 0, (Object)"impl argument is null");
        Validations.checkArgument((method != null ? 1 : 0) != 0, (Object)"method argument is null");
        return new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    return method.invoke(impl, args);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause != null && cause instanceof Exception) {
                        throw (Exception)cause;
                    }
                    throw e;
                }
            }
        };
    }

    public static Object invoke(Object instance, Method method, Object[] args, ExecutionInfo info) throws Exception {
        OrchestrationConfig.LimitsConfig limitsConf = info.getActualLimitsConfig();
        boolean controlConcurrency = limitsConf.getConcurrent() != 0;
        try {
            if (controlConcurrency && limitsConf.getConcurrent() < info.getActualExecutions().incrementAndGet()) {
                throw new ConcurrentOverflowException(info);
            }
            Callable<Object> callable = info.getActualCallableFactory().create(instance, method, args);
            OrchestrationMode.Mode mode = info.getConfig().getModeConfig().getMode();
            if (mode == OrchestrationMode.Mode.SYNC) {
                Object object = ExecutionUtils.invoke(callable, limitsConf.getTime(), limitsConf.getTimeUnit(), info.getActualExecutor());
                return object;
            }
            if (method.getReturnType() != Void.TYPE) {
                StringBuilder sb = new StringBuilder("ASYNC mode currently supported only for 'void' methods");
                sb.append(", invoking in SYNC mode method[").append(method).append("] from[").append(instance.getClass()).append("]");
                LOGGER.warn(sb.toString());
                Object object = ExecutionUtils.invoke(callable, limitsConf.getTime(), limitsConf.getTimeUnit(), info.getActualExecutor());
                return object;
            }
            ExecutionUtils.invokeAsync(callable, limitsConf.getTime(), limitsConf.getTimeUnit(), info.getActualExecutor());
            Object var8_12 = null;
            return var8_12;
        }
        catch (RejectedExecutionException e) {
            throw new ExecutorOverflowException(info);
        }
        catch (TimeoutException e) {
            throw new ExecutionTimeoutException(info);
        }
        finally {
            if (controlConcurrency) {
                info.getActualExecutions().decrementAndGet();
            }
        }
    }

    public static <T> void invokeAsync(final Callable<T> callable, final int time, final TimeUnit timeUnit, final ExecutorService executor) {
        ASYNC_EXECUTOR.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ExecutionUtils.invoke(callable, time, timeUnit, executor);
                }
                catch (Exception e) {
                    LOGGER.error("invokeAsync(callable, " + time + ", " + (Object)((Object)timeUnit) + ", executor) error", (Throwable)e);
                }
            }
        });
    }

    public static <T> T invoke(Callable<T> callable, int time, TimeUnit timeUnit, ExecutorService executor) throws Exception {
        Validations.checkArgument((callable != null ? 1 : 0) != 0, (Object)"callable argument is null");
        Validations.checkArgument((timeUnit != null ? 1 : 0) != 0, (Object)"timeUnit argument is null");
        Validations.checkArgument((executor != null ? 1 : 0) != 0, (Object)"executor argument is null");
        Future<T> future = null;
        try {
            future = executor.submit(callable);
            return time > 0 ? future.get(time, timeUnit) : future.get();
        }
        catch (InterruptedException | RejectedExecutionException | TimeoutException e) {
            if (future != null) {
                future.cancel(true);
            }
            throw e;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw e;
        }
    }

    public static ExecutorService create(OrchestrationConfig.ExecutorConfig config, Object ... nameFormatArgs) {
        Validations.checkArgument((config != null ? 1 : 0) != 0, (Object)"config argument is null");
        Class<? extends ExecutorServiceFactory> factory = config.getFactory();
        if (DefaultExecutorServiceFactory.class == factory) {
            return DefaultExecutorServiceFactory.getInstance().create(config, nameFormatArgs);
        }
        if (SystemExecutorServiceFactory.class == factory) {
            return SystemExecutorServiceFactory.getInstance().create(null, new Object[0]);
        }
        if (AsyncExecutorServiceFactory.class == factory) {
            return AsyncExecutorServiceFactory.getInstance().create(null, new Object[0]);
        }
        try {
            return factory.newInstance().create(config, nameFormatArgs);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new OrchestrationException("Couldn't instantiate ExecutorServiceFactory[" + factory + "]", e);
        }
    }

    public static void terminate(ExecutorService service) {
        ExecutionUtils.shutdown(service, true, false, 1L, TimeUnit.MILLISECONDS);
    }

    public static void shutdown(ExecutorService service, boolean wait, long timeout, TimeUnit unit) {
        ExecutionUtils.shutdown(service, false, wait, timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown(ExecutorService service, boolean terminate, boolean wait, long timeout, TimeUnit unit) {
        Validations.checkArgument((service != null ? 1 : 0) != 0, (Object)"service argument is null");
        Validations.checkArgument((unit != null ? 1 : 0) != 0, (Object)"unit argument is null");
        if (terminate) {
            service.shutdownNow();
            return;
        }
        service.shutdown();
        if (service.isTerminated() || !wait) {
            return;
        }
        try {
            service.awaitTermination(timeout, unit);
        }
        catch (InterruptedException e) {
            LOGGER.warn("service[" + service + "] awaitTermination(" + timeout + ", " + (Object)((Object)unit) + ") is interrupted", (Throwable)e);
        }
        finally {
            if (!service.isTerminated()) {
                service.shutdownNow();
            }
        }
    }
}

