/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.orchestrator.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import net.bolbat.kit.orchestrator.Orchestrator;
import net.bolbat.kit.orchestrator.impl.ExecutionHandler;
import net.bolbat.kit.orchestrator.impl.ExecutionUtils;
import net.bolbat.utils.lang.Validations;
import net.bolbat.utils.reflect.ClassUtils;

public class OrchestratorImpl
implements Orchestrator {
    @Override
    public <T> T init(T target) {
        Validations.checkArgument((target != null ? 1 : 0) != 0, (Object)"target argument is null");
        return this.init(target, ClassUtils.getAllInterfaces(target.getClass()));
    }

    @Override
    public <T> T init(T target, Class<?> ... interfaces) {
        Validations.checkArgument((target != null ? 1 : 0) != 0, (Object)"target argument is null");
        Validations.checkArgument((interfaces != null && interfaces.length > 0 ? 1 : 0) != 0, (Object)"interfaces argument is empty");
        ClassLoader classLoader = target.getClass().getClassLoader();
        ExecutionHandler callHandler = new ExecutionHandler(target, interfaces);
        return (T)Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)((Object)callHandler));
    }

    @Override
    public <T> T invoke(Callable<T> callable, int time, TimeUnit timeUnit, ExecutorService executor) throws Exception {
        Validations.checkArgument((callable != null ? 1 : 0) != 0, (Object)"callable argument is null");
        Validations.checkArgument((time > 0 ? 1 : 0) != 0, (Object)"time argument must be more than 0");
        Validations.checkArgument((timeUnit != null ? 1 : 0) != 0, (Object)"timeUnit argument is null");
        Validations.checkArgument((executor != null ? 1 : 0) != 0, (Object)"executor argument is null");
        return ExecutionUtils.invoke(callable, time, timeUnit, executor);
    }
}

