/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.orchestrator.impl.executor;

import java.util.concurrent.ExecutorService;
import net.bolbat.kit.orchestrator.OrchestrationConfig;
import net.bolbat.kit.orchestrator.impl.ExecutionUtils;
import net.bolbat.kit.orchestrator.impl.executor.DefaultExecutorServiceFactory;
import net.bolbat.kit.orchestrator.impl.executor.ExecutorServiceFactory;

public class AsyncExecutorServiceFactory
implements ExecutorServiceFactory {
    public static final int POOL_CORE_SIZE = 5;
    public static final String THREAD_NAME_FORMAT = "Orchestrator[async]-thread[%1$d]";
    private static final AsyncExecutorServiceFactory INSTANCE = new AsyncExecutorServiceFactory();
    private static final OrchestrationConfig.ExecutorConfig CONFIG = new OrchestrationConfig.ExecutorConfig();
    private volatile ExecutorService executor;

    private AsyncExecutorServiceFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutorService create(OrchestrationConfig.ExecutorConfig config, Object ... nameFormatArgs) {
        if (this.executor == null) {
            OrchestrationConfig.ExecutorConfig executorConfig = CONFIG;
            synchronized (executorConfig) {
                if (this.executor == null) {
                    this.executor = DefaultExecutorServiceFactory.getInstance().create(CONFIG, nameFormatArgs);
                }
            }
        }
        return this.executor;
    }

    public static AsyncExecutorServiceFactory getInstance() {
        return INSTANCE;
    }

    public static ExecutorService getExecutorService() {
        return AsyncExecutorServiceFactory.getInstance().executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tearDown() {
        OrchestrationConfig.ExecutorConfig executorConfig = CONFIG;
        synchronized (executorConfig) {
            if (AsyncExecutorServiceFactory.getInstance().executor != null) {
                ExecutorService toTerminate = AsyncExecutorServiceFactory.getInstance().executor;
                AsyncExecutorServiceFactory.getInstance().executor = null;
                ExecutionUtils.terminate(toTerminate);
            }
        }
    }

    static {
        CONFIG.setFactory(AsyncExecutorServiceFactory.class);
        CONFIG.setCoreSize(5);
        CONFIG.setNameFormat(THREAD_NAME_FORMAT);
    }
}

