/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.orchestrator.impl.executor;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import net.bolbat.kit.orchestrator.OrchestrationConfig;
import net.bolbat.kit.orchestrator.impl.executor.ExecutorServiceFactory;
import net.bolbat.utils.concurrency.ThreadFactoryBuilder;
import net.bolbat.utils.lang.StringUtils;
import net.bolbat.utils.lang.Validations;

public class DefaultExecutorServiceFactory
implements ExecutorServiceFactory {
    private static final DefaultExecutorServiceFactory INSTANCE = new DefaultExecutorServiceFactory();

    private DefaultExecutorServiceFactory() {
    }

    @Override
    public ExecutorService create(OrchestrationConfig.ExecutorConfig config, Object ... nameFormatArgs) {
        Validations.checkArgument((config != null ? 1 : 0) != 0, (Object)"config argument is null");
        String nameFormat = StringUtils.isNotEmpty((String)config.getNameFormat()) ? config.getNameFormat() : "Orchestrator[%1$s]-n[%2$s]-thread[%3$d]";
        ThreadFactoryBuilder factoryBuilder = new ThreadFactoryBuilder().setDaemon(Boolean.valueOf(true)).setPriority(Integer.valueOf(5)).setNameFormat(nameFormat).setNameFormatArgs(nameFormatArgs);
        SynchronousQueue<Runnable> queue = config.getQueueSize() == 0 ? new SynchronousQueue() : new ArrayBlockingQueue(config.getQueueSize());
        int poolMaxSize = config.getMaxSize() == 0 ? Integer.MAX_VALUE : config.getMaxSize();
        ThreadPoolExecutor executor = new ThreadPoolExecutor(config.getCoreSize(), poolMaxSize, config.getKeepAlive(), config.getKeepAliveUnit(), queue, factoryBuilder.build(), new ThreadPoolExecutor.AbortPolicy());
        return executor;
    }

    public static DefaultExecutorServiceFactory getInstance() {
        return INSTANCE;
    }
}

