/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.orchestrator.impl.executor;

import java.util.concurrent.ExecutorService;
import net.bolbat.kit.orchestrator.OrchestrationConfig;
import net.bolbat.kit.orchestrator.impl.ExecutionUtils;
import net.bolbat.kit.orchestrator.impl.executor.DefaultExecutorServiceFactory;
import net.bolbat.kit.orchestrator.impl.executor.ExecutorServiceFactory;

public class SystemExecutorServiceFactory
implements ExecutorServiceFactory {
    public static final int POOL_CORE_SIZE = 5;
    public static final String THREAD_NAME_FORMAT = "Orchestrator[system]-thread[%1$d]";
    private static final SystemExecutorServiceFactory INSTANCE = new SystemExecutorServiceFactory();
    private static final OrchestrationConfig.ExecutorConfig CONFIG = new OrchestrationConfig.ExecutorConfig();
    private volatile ExecutorService executor;

    private SystemExecutorServiceFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutorService create(OrchestrationConfig.ExecutorConfig config, Object ... nameFormatArgs) {
        if (this.executor == null) {
            OrchestrationConfig.ExecutorConfig executorConfig = CONFIG;
            synchronized (executorConfig) {
                if (this.executor == null) {
                    this.executor = DefaultExecutorServiceFactory.getInstance().create(CONFIG, nameFormatArgs);
                }
            }
        }
        return this.executor;
    }

    public static SystemExecutorServiceFactory getInstance() {
        return INSTANCE;
    }

    public static ExecutorService getExecutorService() {
        return SystemExecutorServiceFactory.getInstance().executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tearDown() {
        OrchestrationConfig.ExecutorConfig executorConfig = CONFIG;
        synchronized (executorConfig) {
            if (SystemExecutorServiceFactory.getInstance().executor != null) {
                ExecutorService toTerminate = SystemExecutorServiceFactory.getInstance().executor;
                SystemExecutorServiceFactory.getInstance().executor = null;
                ExecutionUtils.terminate(toTerminate);
            }
        }
    }

    static {
        CONFIG.setFactory(SystemExecutorServiceFactory.class);
        CONFIG.setCoreSize(5);
        CONFIG.setNameFormat(THREAD_NAME_FORMAT);
    }
}

