/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.property;

import java.util.Collection;
import java.util.Map;
import net.bolbat.kit.property.Properties;
import net.bolbat.kit.property.Property;
import net.bolbat.utils.lang.StringUtils;

public abstract class AbstractProperty<ValueType>
implements Property<ValueType> {
    private static final long serialVersionUID = 4300974178177626747L;
    private final Properties type;
    private String key;
    private ValueType value;
    private String group;

    protected AbstractProperty(Properties aType, String aKey, ValueType aValue) {
        if (aType == null) {
            throw new IllegalArgumentException("aType argument is null");
        }
        this.type = aType;
        this.key = aKey;
        this.value = aValue;
    }

    @Override
    public Properties getType() {
        return this.type;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public void setKey(String aKey) {
        this.key = aKey;
    }

    @Override
    public ValueType getValue() {
        return this.value;
    }

    public void setValue(ValueType aValue) {
        this.value = aValue;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public static <ValueType> ValueType get(Class<ValueType> type, Collection<Property<?>> props, String aKey) {
        return AbstractProperty.get(type, props, aKey, null);
    }

    public static <ValueType> ValueType get(Class<ValueType> type, Collection<Property<?>> props, String aKey, ValueType defValue) {
        if (type == null || props == null || StringUtils.isEmpty((String)aKey)) {
            return defValue;
        }
        ValueType value = null;
        for (Property<?> raw : props) {
            if (raw == null || type != raw.getType().getPropertyValueClass() || !aKey.equals(raw.getKey())) continue;
            if (raw.getValue() == null) break;
            value = type.cast(raw.getValue());
        }
        if (value != null) {
            return value;
        }
        return defValue;
    }

    public static <ValueType> ValueType get(Class<ValueType> type, Map<String, Property<?>> props, String aKey) {
        return AbstractProperty.get(type, props, aKey, null);
    }

    public static <ValueType> ValueType get(Class<ValueType> type, Map<String, Property<?>> props, String aKey, ValueType defValue) {
        if (type == null || props == null || StringUtils.isEmpty((String)aKey)) {
            return defValue;
        }
        return AbstractProperty.get(type, props.get(aKey), defValue);
    }

    public static <ValueType> ValueType get(Class<ValueType> type, Property<?> prop) {
        return AbstractProperty.get(type, prop, null);
    }

    public static <ValueType> ValueType get(Class<ValueType> type, Property<?> prop, ValueType defValue) {
        if (type == null || prop == null) {
            return defValue;
        }
        ValueType value = null;
        if (type == prop.getType().getPropertyValueClass() && prop.getValue() != null) {
            value = type.cast(prop.getValue());
        }
        if (value != null) {
            return value;
        }
        return defValue;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append(" [type=").append((Object)this.type);
        builder.append(", key=").append(this.key);
        builder.append(", value=").append(this.value);
        builder.append(", group=").append(this.group);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractProperty)) {
            return false;
        }
        AbstractProperty other = (AbstractProperty)obj;
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }

    @Override
    public AbstractProperty<ValueType> clone() {
        try {
            AbstractProperty result = (AbstractProperty)AbstractProperty.class.cast(super.clone());
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)("Can't clone [" + this + "]"));
        }
    }
}

