/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.property;

import java.util.Date;
import java.util.List;
import net.bolbat.kit.property.BooleanProperty;
import net.bolbat.kit.property.DateProperty;
import net.bolbat.kit.property.DoubleProperty;
import net.bolbat.kit.property.FloatProperty;
import net.bolbat.kit.property.IntegerProperty;
import net.bolbat.kit.property.ListProperty;
import net.bolbat.kit.property.LongProperty;
import net.bolbat.kit.property.Property;
import net.bolbat.kit.property.ShortProperty;
import net.bolbat.kit.property.StringProperty;
import net.bolbat.utils.lang.StringUtils;

public enum Properties {
    STRING(StringProperty.class, String.class),
    BOOLEAN(BooleanProperty.class, Boolean.class),
    SHORT(ShortProperty.class, Short.class),
    INTEGER(IntegerProperty.class, Integer.class),
    LONG(LongProperty.class, Long.class),
    FLOAT(FloatProperty.class, Float.class),
    DOUBLE(DoubleProperty.class, Double.class),
    DATE(DateProperty.class, Date.class),
    LIST(ListProperty.class, List.class);

    private final Class<?> propertyClass;
    private final Class<?> propertyValueClass;

    private Properties(Class<?> aPropertyClass, Class<?> aPropertyValueClass) {
        this.propertyClass = aPropertyClass;
        this.propertyValueClass = aPropertyValueClass;
    }

    public Class<?> getPropertyClass() {
        return this.propertyClass;
    }

    public Class<?> getPropertyValueClass() {
        return this.propertyValueClass;
    }

    public static Properties resolveByName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        for (Properties property : Properties.values()) {
            if (!property.name().equalsIgnoreCase(name)) continue;
            return property;
        }
        return null;
    }

    public static Properties resolveByPropertyClass(Class<? extends Property<?>> aPropertyClass) {
        if (aPropertyClass == null) {
            return null;
        }
        for (Properties property : Properties.values()) {
            if (property.getPropertyClass() != aPropertyClass) continue;
            return property;
        }
        return null;
    }
}

