/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.scheduler;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.bolbat.utils.lang.StringUtils;
import org.configureme.ConfigurationManager;
import org.configureme.annotations.Configure;
import org.configureme.annotations.ConfigureMe;
import org.configureme.annotations.DontConfigure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigureMe
public class SchedulerConfiguration
implements Serializable {
    @DontConfigure
    private static final long serialVersionUID = 2279985778539670636L;
    @DontConfigure
    private static final Logger LOGGER = LoggerFactory.getLogger(SchedulerConfiguration.class);
    @DontConfigure
    private static final Map<String, SchedulerConfiguration> CACHE = new HashMap<String, SchedulerConfiguration>();
    @DontConfigure
    private static final Object CACHE_LOCK = new Object();
    @DontConfigure
    private static final String DEFAULT_SCHEDULER_INSTANCE_ID = "AUTO";
    @DontConfigure
    private static final boolean DEFAULT_SCHEDULER_SKIP_UPDATE_CHECK = true;
    @DontConfigure
    private static final String DEFAULT_THREAD_POOL_CLASS = "org.quartz.simpl.SimpleThreadPool";
    @DontConfigure
    private static final int DEFAULT_THREAD_POOL_TREAD_COUNT = 1;
    @DontConfigure
    private static final String DEFAULT_THREAD_JOB_STORE_CLASS = "org.quartz.simpl.RAMJobStore";
    @Configure
    private String schedulerInstanceName = null;
    @Configure
    private String schedulerInstanceId = "AUTO";
    @Configure
    private boolean schedulerSkipUpdateCheck = true;
    @Configure
    private String threadPoolClass = "org.quartz.simpl.SimpleThreadPool";
    @Configure
    private int threadPoolCount = 1;
    @Configure
    private String threadJobStoreClass = "org.quartz.simpl.RAMJobStore";

    private SchedulerConfiguration(String configurationName) {
        try {
            if (StringUtils.isEmpty((String)configurationName)) {
                ConfigurationManager.INSTANCE.configure((Object)this);
            } else {
                ConfigurationManager.INSTANCE.configureBeanAs((Object)this, configurationName);
            }
        }
        catch (RuntimeException e) {
            LOGGER.warn("Configuration fail[" + e.getMessage() + "]. Relaying on defaults.");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Configured with[" + this.toString() + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SchedulerConfiguration getInstance(String configuration) {
        String cacheKey = String.valueOf(configuration);
        SchedulerConfiguration cached = CACHE.get(cacheKey);
        if (cached != null) {
            return cached;
        }
        Object object = CACHE_LOCK;
        synchronized (object) {
            SchedulerConfiguration secondCheck = CACHE.get(cacheKey);
            if (secondCheck != null) {
                return secondCheck;
            }
            SchedulerConfiguration config = new SchedulerConfiguration(configuration);
            CACHE.put(cacheKey, config);
            return config;
        }
    }

    public String getSchedulerInstanceName() {
        return this.schedulerInstanceName;
    }

    public void setSchedulerInstanceName(String schedulerInstanceName) {
        this.schedulerInstanceName = schedulerInstanceName;
    }

    public String getSchedulerInstanceId() {
        return this.schedulerInstanceId;
    }

    public void setSchedulerInstanceId(String schedulerInstanceId) {
        this.schedulerInstanceId = schedulerInstanceId;
    }

    public boolean isSchedulerSkipUpdateCheck() {
        return this.schedulerSkipUpdateCheck;
    }

    public void setSchedulerSkipUpdateCheck(boolean schedulerSkipUpdateCheck) {
        this.schedulerSkipUpdateCheck = schedulerSkipUpdateCheck;
    }

    public String getThreadPoolClass() {
        return this.threadPoolClass;
    }

    public void setThreadPoolClass(String threadPoolClass) {
        this.threadPoolClass = threadPoolClass;
    }

    public int getThreadPoolCount() {
        return this.threadPoolCount;
    }

    public void setThreadPoolCount(int threadPoolCount) {
        this.threadPoolCount = threadPoolCount;
    }

    public String getThreadJobStoreClass() {
        return this.threadJobStoreClass;
    }

    public void setThreadJobStoreClass(String threadJobStoreClass) {
        this.threadJobStoreClass = threadJobStoreClass;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("[schedulerInstanceName=").append(this.schedulerInstanceName);
        sb.append(", schedulerInstanceId=").append(this.schedulerInstanceId);
        sb.append(", schedulerSkipUpdateCheck=").append(this.schedulerSkipUpdateCheck);
        sb.append(", threadPoolClass=").append(this.threadPoolClass);
        sb.append(", threadPoolCount=").append(this.threadPoolCount);
        sb.append(", threadJobStoreClass=").append(this.threadJobStoreClass);
        sb.append(']');
        return sb.toString();
    }
}

