/*
 * Decompiled with CFR 0.152.
 */
package net.bolbat.kit.scheduler;

import java.util.Properties;
import java.util.UUID;
import net.bolbat.kit.scheduler.SchedulerConfiguration;
import net.bolbat.kit.scheduler.SchedulerException;
import net.bolbat.kit.scheduler.TaskConfiguration;
import net.bolbat.utils.lang.StringUtils;
import net.bolbat.utils.logging.LoggingUtils;
import org.quartz.Scheduler;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerConfigurationFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchedulerConfigurationFactory.class);
    private static final String PARAM_SCHEDULER_INSTANCE_NAME = "org.quartz.scheduler.instanceName";
    private static final String PARAM_SCHEDULER_INSTANCE_ID = "org.quartz.scheduler.instanceId";
    private static final String PARAM_SCHEDULER_SKIP_UPDATE_CHECK = "org.quartz.scheduler.skipUpdateCheck";
    private static final String PARAM_THREAD_POOL_CLASS = "org.quartz.threadPool.class";
    private static final String PARAM_THREAD_POOL_TREAD_COUNT = "org.quartz.threadPool.threadCount";
    private static final String PARAM_THREAD_JOB_STORE_CLASS = "org.quartz.jobStore.class";

    public static Scheduler getConfiguration(TaskConfiguration task) throws SchedulerException {
        if (task == null) {
            throw new IllegalArgumentException("Parameter task is null");
        }
        try {
            if (task.getConfigType() == null) {
                return new StdSchedulerFactory(SchedulerConfigurationFactory.getConfigureMeConfiguration(null)).getScheduler();
            }
            switch (task.getConfigType()) {
                case CONFIGURE_ME: {
                    return new StdSchedulerFactory(SchedulerConfigurationFactory.getConfigureMeConfiguration(task.getConfig())).getScheduler();
                }
                case PROPERTY: {
                    return new StdSchedulerFactory(task.getConfig()).getScheduler();
                }
            }
            return new StdSchedulerFactory(SchedulerConfigurationFactory.getConfigureMeConfiguration(task.getConfig())).getScheduler();
        }
        catch (org.quartz.SchedulerException e) {
            String message = "getConfiguration(...) scheduler initialization fail.";
            LOGGER.error(LoggingUtils.FATAL, message, (Throwable)e);
            throw new SchedulerException(message, e);
        }
    }

    private static Properties getConfigureMeConfiguration(String fileName) {
        Properties properties = new Properties();
        SchedulerConfiguration config = SchedulerConfiguration.getInstance(fileName);
        properties.put(PARAM_SCHEDULER_INSTANCE_NAME, StringUtils.isNotEmpty((String)config.getSchedulerInstanceName()) ? config.getSchedulerInstanceName() : UUID.randomUUID().toString());
        properties.put(PARAM_SCHEDULER_INSTANCE_ID, config.getSchedulerInstanceId());
        properties.put(PARAM_SCHEDULER_SKIP_UPDATE_CHECK, String.valueOf(config.isSchedulerSkipUpdateCheck()));
        properties.put(PARAM_THREAD_POOL_CLASS, config.getThreadPoolClass());
        properties.put(PARAM_THREAD_POOL_TREAD_COUNT, String.valueOf(config.getThreadPoolCount()));
        properties.put(PARAM_THREAD_JOB_STORE_CLASS, config.getThreadJobStoreClass());
        return properties;
    }
}

